/*
 * Decompiled with CFR 0.152.
 */
package org.winterblade.minecraft.scripting.internal;

import com.google.common.base.Defaults;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.api.scripting.ScriptUtils;
import jdk.nashorn.internal.runtime.ScriptObject;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.winterblade.minecraft.scripting.NashornLibMod;
import org.winterblade.minecraft.scripting.api.IScriptObjectDeserializer;

public class ScriptObjectParser {
    private static final Map<String, IScriptObjectDeserializer> deserializerMap = new HashMap<String, IScriptObjectDeserializer>();

    public static void writeScriptObjectToClass(ScriptObjectMirror data, Object writeTo, Logger logger) {
        Class<?> cls = writeTo.getClass();
        for (String key : data.keySet()) {
            try {
                ScriptObjectParser.updateField(cls, key, writeTo, data.get(key), logger);
            }
            catch (Exception e) {
                logger.warn("Unable to deserialize '" + key + "' from the provided data.", (Throwable)e);
            }
        }
    }

    public static void registerDeserializerClasses(Map<Type, Class<IScriptObjectDeserializer>> deserializers) {
        for (Map.Entry<Type, Class<IScriptObjectDeserializer>> deserializer : deserializers.entrySet()) {
            Class<IScriptObjectDeserializer> instClass = deserializer.getValue();
            try {
                deserializerMap.put(deserializer.getKey().getClassName(), instClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                NashornLibMod.logger.warn("Unable to register deserializer '" + instClass.getName() + "'.", (Throwable)e);
            }
        }
    }

    public static <T> T convertData(Object input, Class<T> cls, Logger logger) {
        if (cls.isArray()) {
            Class<?> componentType = cls.getComponentType();
            if (!ScriptObjectMirror.class.isAssignableFrom(input.getClass())) {
                return ScriptObjectParser.wrapSingleton(input, logger, componentType);
            }
            ScriptObjectMirror mirror = (ScriptObjectMirror)input;
            if (mirror.size() <= 0 || mirror.isFunction()) {
                return (T)Array.newInstance(cls.getComponentType(), 0);
            }
            if (!mirror.isArray()) {
                return ScriptObjectParser.wrapSingleton(input, logger, componentType);
            }
            Object[] items = (Object[])ScriptUtils.convert(input, Object[].class);
            Object[] values = (Object[])Array.newInstance(componentType, items.length);
            for (int i = 0; i < items.length; ++i) {
                try {
                    values[i] = ScriptObjectParser.convertData(items[i], componentType, logger);
                    continue;
                }
                catch (Exception e) {
                    values[i] = null;
                }
            }
            return (T)values;
        }
        try {
            if (deserializerMap.containsKey(cls.getName())) {
                IScriptObjectDeserializer deserializer = deserializerMap.get(cls.getName());
                return (T)deserializer.Deserialize(input);
            }
            if (!ScriptObjectMirror.class.isAssignableFrom(input.getClass()) && !ScriptObject.class.isAssignableFrom(input.getClass())) {
                return (T)ScriptUtils.convert(input, cls);
            }
            ScriptObjectMirror mirror = ScriptObjectMirror.class.isAssignableFrom(input.getClass()) ? (ScriptObjectMirror)input : ScriptUtils.wrap((ScriptObject)input);
            if (mirror.isFunction()) {
                return (T)ScriptUtils.convert(input, cls);
            }
            T output = cls.newInstance();
            for (Map.Entry<String, Object> entry : mirror.entrySet()) {
                Field f = ScriptObjectParser.getFieldByName(cls, entry.getKey());
                if (f == null) continue;
                ScriptObjectParser.updateField(cls, entry.getKey(), output, entry.getValue(), logger);
            }
            return output;
        }
        catch (Throwable t) {
            logger.warn("Error converting data to type '" + cls.getName(), t);
            return (T)Defaults.defaultValue(cls);
        }
    }

    private static <T> T wrapSingleton(Object input, Logger logger, Class componentType) {
        Object[] values = (Object[])Array.newInstance(componentType, 1);
        values[0] = ScriptObjectParser.convertData(input, componentType, logger);
        return (T)values;
    }

    private static void updateField(Class cls, String field, Object writeTo, Object value, Logger logger) throws InvocationTargetException, IllegalAccessException {
        Method m = ScriptObjectParser.getFirstMethodByName(cls, field);
        if (m != null) {
            Class<?> c = m.getParameterTypes()[0];
            m.invoke(writeTo, ScriptObjectParser.convertData(value, c, logger));
            return;
        }
        Field f = ScriptObjectParser.getFieldByName(cls, field);
        if (f == null) {
            return;
        }
        f.setAccessible(true);
        f.set(writeTo, ScriptObjectParser.convertData(value, f.getType(), logger));
    }

    private static Method getFirstMethodByName(Class cls, String name) {
        Method[] methods = cls.getMethods();
        name = name.toLowerCase();
        for (Method method : methods) {
            if (!method.getName().toLowerCase().equals("set" + name) || method.getParameterCount() != 1) continue;
            return method;
        }
        return null;
    }

    private static Field getFieldByName(Class cls, String name) {
        Field field = null;
        Class cur = cls;
        do {
            try {
                field = cur.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            cur = cur.getSuperclass();
        } while (field == null && cur != null);
        if (field == null) {
            return null;
        }
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers) || Modifier.isAbstract(modifiers) ? null : field;
    }
}

