/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.InterfaceDependancies;
import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.ObfMapping;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class InterfaceDependancyTransformer
implements IClassTransformer {
    public byte[] transform(String name, String tname, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode cnode = ASMHelper.createClassNode((byte[])bytes);
        boolean hasDependancyInterfaces = false;
        if (cnode.visibleAnnotations != null) {
            for (AnnotationNode ann : cnode.visibleAnnotations) {
                if (!ann.desc.equals(Type.getDescriptor(InterfaceDependancies.class))) continue;
                hasDependancyInterfaces = true;
                break;
            }
        }
        if (!hasDependancyInterfaces) {
            return bytes;
        }
        hasDependancyInterfaces = false;
        Iterator iterator = cnode.interfaces.iterator();
        while (iterator.hasNext()) {
            try {
                Launch.classLoader.findClass(new ObfMapping((String)iterator.next()).toRuntime().javaClass());
            }
            catch (ClassNotFoundException cnfe) {
                iterator.remove();
                hasDependancyInterfaces = true;
            }
        }
        if (!hasDependancyInterfaces) {
            return bytes;
        }
        return ASMHelper.createBytes((ClassNode)cnode, (int)0);
    }
}

