/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.featurehack.config;

import codechicken.core.featurehack.config.CCConfigGuiFactory;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.util.ReflectionManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ConfigGuiInjector {
    private static boolean hasInit = false;

    public static void init() {
        if (hasInit || !FMLLaunchHandler.side().isClient()) {
            return;
        }
        hasInit = true;
        HashMap<ModContainer, CCConfigGuiFactory> containersToInject = new HashMap<ModContainer, CCConfigGuiFactory>();
        for (ModContainer modContainer : Loader.instance().getModList()) {
            CCConfigGuiFactory guiFactory;
            if (modContainer.getMod() == null || (guiFactory = modContainer.getMod().getClass().getAnnotation(CCConfigGuiFactory.class)) == null || guiFactory.configObject() == null) continue;
            containersToInject.put(modContainer, guiFactory);
        }
        for (Map.Entry entry : containersToInject.entrySet()) {
            ConfigFile configFile = ConfigGuiInjector.processAnnotationData(((CCConfigGuiFactory)entry.getValue()).configObject());
        }
    }

    private static ConfigFile processAnnotationData(String data) {
        ConfigFile file;
        block4: {
            try {
                int lastDot = data.lastIndexOf(".");
                String className = data.substring(0, lastDot);
                String fieldOrMethod = data.substring(lastDot + 1, data.length());
                Class<?> clazz = Class.forName(className);
                if (ReflectionManager.hasField(clazz, (String)fieldOrMethod)) {
                    file = (ConfigFile)ReflectionManager.getField(clazz, ConfigFile.class, null, (String)fieldOrMethod);
                    break block4;
                }
                Method method = clazz.getDeclaredMethod(fieldOrMethod, new Class[0]);
                Object methodReturn = method.invoke(null, new Object[0]);
                if (methodReturn instanceof ConfigFile) {
                    file = (ConfigFile)methodReturn;
                    break block4;
                }
                throw new Exception(String.format("Method %s does not return an instance of ConfigFile!", fieldOrMethod));
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (String)"CodeChickenCore", (Object[])new Object[]{"Unable to parse data from CCConfigGuiFactory! There is no method or field! Data: [%s]", data});
                e.printStackTrace();
                file = null;
            }
        }
        return file;
    }
}

