/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.overworld.BOPBiome;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class BiomeGenWasteland
extends BOPBiome {
    public BiomeGenWasteland() {
        super("wasteland", new BOPBiome.PropsBuilder("Wasteland").withGuiColour(5919808).withTemperature(Float.valueOf(2.0f)).withRainfall(Float.valueOf(0.0f)).withWaterColor(15073024).withRainDisabled());
        this.terrainSettings.avgHeight(66.0).heightVariation(1.0, 5.0);
        this.field_76752_A = BOPBlocks.dried_sand.func_176223_P();
        this.field_76753_B = BOPBlocks.dried_sand.func_176223_P();
        this.skyColor = 9477744;
        this.seaFloorBlock = BOPBlocks.dried_sand.func_176223_P();
        this.canGenerateRivers = false;
        this.canGenerateVillages = false;
        this.canSpawnInBiome = false;
        this.beachBiomeLocation = null;
        this.addWeight(BOPClimates.WASTELAND, 50);
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        IBlockPosQuery emptyDriedSand = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(0.3f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("dead_tree", 3, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(0).foliageDensity(0.5).log(BOPWoods.DEAD)).leaves(Blocks.field_150350_a.func_176223_P())).create());
        treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(1).log(BOPWoods.DEAD)).leaves(BOPTrees.DEAD)).create());
        this.addGenerator("dead_grass", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(1.0f)).with(BOPPlants.DEADGRASS)).create());
        this.addGenerator("desertgrass", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.DESERTGRASS)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.05f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("wilted_lily", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.WILTED_LILY)).create());
        this.addGenerator("lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.05f)).waterLakeForBiome(this).create());
        this.addGenerator("poison_lakes", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.05f)).waterLakeForBiome(this).liquid(BOPBlocks.poison).frozenLiquid((IBlockState)null).create());
        this.addGenerator("ruby", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.RUBY)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("ruby");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.LIQUID_POISON)) {
            this.removeGenerator("poison_lakes");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("flowers");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            IBlockPosQuery emptyDriedSand = BlockQuery.buildAnd().withAirAbove().states(this.field_76752_A).create();
            GeneratorWeighted treeGenerator = new GeneratorWeighted(0.3f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("dead_tree", 3, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(0).foliageDensity(0.5).log(BlockPlanks.EnumType.OAK)).leaves(Blocks.field_150350_a.func_176223_P())).create());
            treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().placeOn(emptyDriedSand)).minHeight(5)).maxHeight(12)).foliageHeight(1).log(BlockPlanks.EnumType.DARK_OAK)).leaves(BlockPlanks.EnumType.DARK_OAK)).create());
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            this.removeGenerator("dead_grass");
            this.removeGenerator("desertgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 10330232;
    }

    public int func_180625_c(BlockPos pos) {
        return 0x999E55;
    }

    public int getFogColour(BlockPos pos) {
        return 12106885;
    }

    public float getFogDensity(BlockPos pos) {
        return 0.3f;
    }
}

