/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.block.BlockBOPDecoration;
import biomesoplenty.common.block.BlockBOPDoubleDecoration;
import biomesoplenty.common.block.BlockBOPDoublePlant;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorDoubleFlora
extends GeneratorReplacing {
    protected IBlockState withTop;
    protected int generationAttempts;

    public GeneratorDoubleFlora(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, IBlockState withTop, int generationAttempts) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.withTop = withTop;
        this.generationAttempts = generationAttempts;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        Block bottomBlock = this.with.func_177230_c();
        for (int i = 0; i < this.generationAttempts; ++i) {
            boolean canStay;
            BlockPos genPos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!this.placeOn.matches(world, genPos.func_177977_b()) || !this.replace.matches(world, genPos) || !this.replace.matches(world, genPos.func_177984_a()) || genPos.func_177956_o() >= 254 || !(canStay = bottomBlock instanceof BlockBOPDecoration ? ((BlockBOPDecoration)bottomBlock).canBlockStay(world, genPos, this.with) : (bottomBlock instanceof BlockBush ? ((BlockBush)bottomBlock).func_176196_c(world, genPos) : bottomBlock.func_176196_c(world, genPos)))) continue;
            world.func_180501_a(genPos, this.with, 2);
            world.func_180501_a(genPos.func_177984_a(), this.withTop, 2);
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.with = conf.getBlockState("with", this.with);
        this.withTop = conf.getBlockState("withTop", this.withTop);
        this.generationAttempts = conf.getInt("generationAttempts", this.generationAttempts);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorDoubleFlora>
    implements IGenerator.IGeneratorBuilder<GeneratorDoubleFlora> {
        protected int generationAttempts;
        protected IBlockState withTop;

        public Builder generationAttempts(int a) {
            this.generationAttempts = a;
            return (Builder)this.self();
        }

        @Override
        public Builder with(IBlockState a) {
            this.with = a;
            this.withTop = a;
            return (Builder)this.self();
        }

        public Builder with(IBlockState bottom, IBlockState top) {
            this.with = bottom;
            this.withTop = top;
            return (Builder)this.self();
        }

        public Builder with(BlockBOPDoublePlant.DoublePlantType type) {
            this.with = BOPBlocks.double_plant.func_176223_P().func_177226_a((IProperty)BlockBOPDoublePlant.VARIANT, (Comparable)((Object)type)).func_177226_a((IProperty)BlockBOPDoublePlant.HALF, (Comparable)((Object)BlockBOPDoubleDecoration.Half.LOWER));
            this.withTop = BOPBlocks.double_plant.func_176223_P().func_177226_a((IProperty)BlockBOPDoublePlant.VARIANT, (Comparable)((Object)type)).func_177226_a((IProperty)BlockBOPDoublePlant.HALF, (Comparable)((Object)BlockBOPDoubleDecoration.Half.UPPER));
            return (Builder)this.self();
        }

        public Builder with(BlockDoublePlant.EnumPlantType type) {
            this.with = Blocks.field_150398_cm.func_176203_a(type.func_176936_a());
            this.withTop = Blocks.field_150398_cm.func_176203_a(8);
            return this;
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.anything;
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151579_a);
            this.with = BOPBlocks.double_plant.func_176223_P().func_177226_a((IProperty)BlockBOPDoublePlant.VARIANT, (Comparable)((Object)BlockBOPDoublePlant.DoublePlantType.FLAX)).func_177226_a((IProperty)BlockBOPDoublePlant.HALF, (Comparable)((Object)BlockBOPDoubleDecoration.Half.LOWER));
            this.withTop = BOPBlocks.double_plant.func_176223_P().func_177226_a((IProperty)BlockBOPDoublePlant.VARIANT, (Comparable)((Object)BlockBOPDoublePlant.DoublePlantType.FLAX)).func_177226_a((IProperty)BlockBOPDoublePlant.HALF, (Comparable)((Object)BlockBOPDoubleDecoration.Half.UPPER));
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_SURFACE;
            this.generationAttempts = 32;
        }

        @Override
        public GeneratorDoubleFlora create() {
            return new GeneratorDoubleFlora(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.withTop, this.generationAttempts);
        }
    }
}

