/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.apache.commons.lang3.tuple.Pair;

public class GeneratorBigTree
extends GeneratorTreeBase {
    private Random random;
    private World world;
    private BlockPos origin;
    private int height;
    private int trunkHeight;
    private double trunkHeightScale = 0.618;
    private double branchSlope = 0.381;
    private double widthScale = 1.0;
    private int trunkWidth = 1;
    private boolean updateNeighbours;
    private int foliageHeight;
    private double foliageDensity;
    private List<FoliageCoords> foliageCoords;

    public GeneratorBigTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight, int trunkWidth, int foliageHeight, double foliageDensity, boolean updateNeighbours) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight);
        this.foliageHeight = foliageHeight;
        this.foliageDensity = foliageDensity;
        this.trunkWidth = trunkWidth;
        this.updateNeighbours = updateNeighbours;
    }

    protected void prepare() {
        int relativeY;
        int clustersPerY;
        this.trunkHeight = (int)((double)this.height * this.trunkHeightScale);
        if (this.trunkHeight >= this.height) {
            this.trunkHeight = this.height - 1;
        }
        if ((clustersPerY = (int)(1.382 + Math.pow(this.foliageDensity * (double)this.height / 13.0, 2.0))) < 1) {
            clustersPerY = 1;
        }
        int trunkTop = this.origin.func_177956_o() + this.trunkHeight;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoords(this.origin.func_177981_b(relativeY), trunkTop));
        for (relativeY = this.height - this.foliageHeight; relativeY >= 0; --relativeY) {
            float treeShape = this.treeShape(relativeY);
            if (treeShape < 0.0f) continue;
            for (int i = 0; i < clustersPerY; ++i) {
                BlockPos checkEnd;
                double z;
                double angle;
                double radius = this.widthScale * (double)treeShape * ((double)this.random.nextFloat() + 0.328);
                double x = radius * Math.sin(angle = (double)(this.random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos checkStart = this.origin.func_177963_a(x, (double)(relativeY - 1), z = radius * Math.cos(angle) + 0.5);
                if (this.checkLine(checkStart, checkEnd = checkStart.func_177981_b(this.foliageHeight)) != -1) continue;
                int dx = this.origin.func_177958_n() - checkStart.func_177958_n();
                int dz = this.origin.func_177952_p() - checkStart.func_177952_p();
                double height = (double)checkStart.func_177956_o() - Math.sqrt(dx * dx + dz * dz) * this.branchSlope;
                int branchTop = height > (double)trunkTop ? trunkTop : (int)height;
                BlockPos checkBranchBase = new BlockPos(this.origin.func_177958_n(), branchTop, this.origin.func_177952_p());
                if (this.checkLine(checkBranchBase, checkStart) != -1) continue;
                this.foliageCoords.add(new FoliageCoords(checkStart, checkBranchBase.func_177956_o()));
            }
        }
    }

    private void crossection(BlockPos pos, float radius) {
        int r = (int)((double)radius + 0.618);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                BlockPos checkedPos;
                if (!(Math.pow((double)Math.abs(dx) + 0.5, 2.0) + Math.pow((double)Math.abs(dz) + 0.5, 2.0) <= (double)(radius * radius)) || !this.replace.matches(this.world, checkedPos = pos.func_177982_a(dx, 0, dz))) continue;
                if (this.altLeaves != null) {
                    int rand = new Random().nextInt(4);
                    if (rand == 0) {
                        this.func_175903_a(this.world, checkedPos, this.altLeaves.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    this.func_175903_a(this.world, checkedPos, this.leaves.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                this.func_175903_a(this.world, checkedPos, this.leaves.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected float treeShape(int y) {
        if ((float)y < (float)this.height * 0.3f) {
            return -1.0f;
        }
        float radius = (float)this.height / 2.0f;
        float adjacent = radius - (float)y;
        float distance = MathHelper.func_76129_c((float)(radius * radius - adjacent * adjacent));
        if (adjacent == 0.0f) {
            distance = radius;
        } else if (Math.abs(adjacent) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    protected float foliageShape(int y) {
        if (y < 0 || y >= this.foliageHeight) {
            return -1.0f;
        }
        if (y == 0 || y == this.foliageHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    private void foliageCluster(BlockPos blockPos) {
        for (int y = 0; y < this.foliageHeight; ++y) {
            this.crossection(blockPos.func_177981_b(y), this.foliageShape(y));
        }
    }

    private void limb(BlockPos startPos, BlockPos endPos, IBlockState state) {
        BlockPos delta = endPos.func_177982_a(-startPos.func_177958_n(), -startPos.func_177956_o(), -startPos.func_177952_p());
        int steps = this.getSteps(delta);
        float dx = (float)delta.func_177958_n() / (float)steps;
        float dy = (float)delta.func_177956_o() / (float)steps;
        float dz = (float)delta.func_177952_p() / (float)steps;
        for (int i = 0; i <= steps; ++i) {
            BlockPos blockPos = startPos.func_177963_a((double)(0.5f + (float)i * dx), (double)(0.5f + (float)i * dy), (double)(0.5f + (float)i * dz));
            BlockLog.EnumAxis logAxis = this.getLogAxis(startPos, blockPos);
            this.func_175903_a(this.world, blockPos, state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)logAxis));
        }
    }

    private int getSteps(BlockPos pos) {
        int absX = MathHelper.func_76130_a((int)pos.func_177958_n());
        int absY = MathHelper.func_76130_a((int)pos.func_177956_o());
        int absZ = MathHelper.func_76130_a((int)pos.func_177952_p());
        if (absZ > absX && absZ > absY) {
            return absZ;
        }
        if (absY > absX) {
            return absY;
        }
        return absX;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    private BlockLog.EnumAxis getLogAxis(BlockPos startPos, BlockPos endPos) {
        int zDiff;
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.Y;
        int xDiff = Math.abs(endPos.func_177958_n() - startPos.func_177958_n());
        int maxDiff = Math.max(xDiff, zDiff = Math.abs(endPos.func_177952_p() - startPos.func_177952_p()));
        if (maxDiff > 0) {
            if (xDiff == maxDiff) {
                axis = BlockLog.EnumAxis.X;
            } else if (zDiff == maxDiff) {
                axis = BlockLog.EnumAxis.Z;
            }
        }
        return axis;
    }

    private void makeFoliage() {
        for (FoliageCoords foliageCoord : this.foliageCoords) {
            this.foliageCluster(foliageCoord);
        }
    }

    protected boolean trimBranches(int localY) {
        return (double)localY >= (double)this.height * 0.2;
    }

    private void makeTrunk() {
        BlockPos start = this.origin;
        BlockPos end = this.origin.func_177981_b(this.trunkHeight);
        IBlockState materialState = this.log;
        this.limb(start, end, materialState);
        if (this.trunkWidth == 2) {
            this.limb(start.func_177974_f(), end.func_177974_f(), materialState);
            this.limb(start.func_177974_f().func_177968_d(), end.func_177974_f().func_177968_d(), materialState);
            this.limb(start.func_177968_d(), end.func_177968_d(), materialState);
        }
    }

    private void makeBranches() {
        for (FoliageCoords endCoord : this.foliageCoords) {
            int branchBase = endCoord.getBranchBase();
            BlockPos baseCoord = new BlockPos(this.origin.func_177958_n(), branchBase, this.origin.func_177952_p());
            if (!this.trimBranches(branchBase - this.origin.func_177956_o())) continue;
            this.limb(baseCoord, endCoord, this.log);
        }
    }

    private int checkLine(BlockPos startPos, BlockPos endPos) {
        BlockPos delta = endPos.func_177982_a(-startPos.func_177958_n(), -startPos.func_177956_o(), -startPos.func_177952_p());
        int steps = this.getGreatestDistance(delta);
        float dx = (float)delta.func_177958_n() / (float)steps;
        float dy = (float)delta.func_177956_o() / (float)steps;
        float dz = (float)delta.func_177952_p() / (float)steps;
        if (steps == 0) {
            return -1;
        }
        for (int i = 0; i <= steps; ++i) {
            BlockPos deltaPos = startPos.func_177963_a((double)(0.5f + (float)i * dx), (double)(0.5f + (float)i * dy), (double)(0.5f + (float)i * dz));
            if (this.replace.matches(this.world, deltaPos)) continue;
            return i;
        }
        return -1;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.world = world;
        this.origin = pos;
        this.random = new Random(rand.nextLong());
        this.height = this.random.nextInt(this.maxHeight - this.minHeight) + this.minHeight;
        if (!this.checkLocation()) {
            this.world = null;
            return false;
        }
        try {
            this.prepare();
            this.makeFoliage();
            this.makeTrunk();
            this.makeBranches();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.world = null;
        return true;
    }

    private boolean checkLocation() {
        BlockPos down = this.origin.func_177977_b();
        IBlockState state = this.world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)this.world, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
        if (!isSoil && !this.placeOn.matches(this.world, down)) {
            return false;
        }
        int allowedHeight = this.checkLine(this.origin, this.origin.func_177981_b(this.height - 1));
        if (this.trunkWidth == 2) {
            allowedHeight = Math.min(this.checkLine(this.origin.func_177974_f(), this.origin.func_177974_f().func_177981_b(this.height - 1)), allowedHeight);
            allowedHeight = Math.min(this.checkLine(this.origin.func_177974_f().func_177968_d(), this.origin.func_177974_f().func_177968_d().func_177981_b(this.height - 1)), allowedHeight);
            allowedHeight = Math.min(this.checkLine(this.origin.func_177968_d(), this.origin.func_177968_d().func_177981_b(this.height - 1)), allowedHeight);
        }
        if (allowedHeight == -1) {
            return true;
        }
        if (allowedHeight < this.minHeight) {
            return false;
        }
        this.height = allowedHeight;
        return true;
    }

    public void func_175903_a(World world, BlockPos pos, IBlockState state) {
        if (this.updateNeighbours) {
            world.func_180501_a(pos, state, 3);
        } else {
            world.func_180501_a(pos, state, 2);
        }
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.updateNeighbours = conf.getBool("updateNeighbours", this.updateNeighbours);
        int minHeight = conf.getInt("minHeight", this.minHeight);
        int maxHeight = conf.getInt("maxHeight", this.maxHeight);
        Pair<Integer, Integer> heights = GeneratorUtils.validateMinMaxHeight(minHeight, maxHeight);
        this.minHeight = (Integer)heights.getLeft();
        this.maxHeight = (Integer)heights.getRight();
        this.log = conf.getBlockState("logState", this.log);
        this.leaves = conf.getBlockState("leavesState", this.leaves);
    }

    private static class FoliageCoords
    extends BlockPos {
        private final int branchBase;

        public FoliageCoords(BlockPos pos, int branchBase) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }

    public static class Builder
    extends GeneratorTreeBase.InnerBuilder<Builder, GeneratorBigTree>
    implements IGenerator.IGeneratorBuilder<GeneratorBigTree> {
        private int trunkWidth;
        private int foliageHeight;
        private double foliageDensity;

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.fertile;
            this.replace = BlockQueries.airOrLeaves;
            this.log = Blocks.field_150364_r.func_176223_P();
            this.leaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
            this.vine = null;
            this.hanging = null;
            this.trunkFruit = null;
            this.altLeaves = null;
            this.minHeight = 5;
            this.maxHeight = 17;
            this.trunkWidth = 1;
            this.foliageHeight = 4;
            this.foliageDensity = 1.0;
        }

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return (Builder)this.self();
        }

        public Builder foliageHeight(int a) {
            this.foliageHeight = a;
            return (Builder)this.self();
        }

        public Builder foliageDensity(double a) {
            this.foliageDensity = a;
            return (Builder)this.self();
        }

        @Override
        public GeneratorBigTree create() {
            return new GeneratorBigTree(this.amountPerChunk, this.placeOn, this.replace, this.log, this.leaves, this.vine, this.hanging, this.trunkFruit, this.altLeaves, this.minHeight, this.maxHeight, this.trunkWidth, this.foliageHeight, this.foliageDensity, false);
        }
    }
}

