/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator.tree;

import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.world.generator.tree.GeneratorTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class GeneratorHugeTree
extends GeneratorTreeBase {
    protected GeneratorHugeTree(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState log, IBlockState leaves, IBlockState vine, IBlockState hanging, IBlockState trunkFruit, IBlockState altLeaves, int minHeight, int maxHeight) {
        super(amountPerChunk, placeOn, replace, log, leaves, vine, hanging, trunkFruit, altLeaves, minHeight, maxHeight);
    }

    protected int chooseHeight(Random rand) {
        return GeneratorUtils.nextIntBetween(rand, this.minHeight, this.maxHeight);
    }

    private boolean checkEnoughSpace(World worldIn, BlockPos pos, int height) {
        for (int y = 0; y <= 1 + height; ++y) {
            int radius = y == 0 ? 1 : 2;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(worldIn, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkSoil(BlockPos pos, World worldIn) {
        BlockPos soilPos = pos.func_177977_b();
        if (!this.placeOn.matches(worldIn, soilPos)) {
            return false;
        }
        Block block = worldIn.func_180495_p(soilPos).func_177230_c();
        this.onPlantGrow(worldIn, soilPos, pos);
        this.onPlantGrow(worldIn, soilPos.func_177974_f(), pos);
        this.onPlantGrow(worldIn, soilPos.func_177968_d(), pos);
        this.onPlantGrow(worldIn, soilPos.func_177968_d().func_177974_f(), pos);
        return true;
    }

    protected boolean canGrowHere(World worldIn, Random rand, BlockPos pos, int height) {
        return this.checkEnoughSpace(worldIn, pos, height) && this.checkSoil(pos, worldIn);
    }

    protected void addWideLeafLayer(World worldIn, BlockPos pos, int radius) {
        int rSquared = radius * radius;
        for (int x = -radius; x <= radius + 1; ++x) {
            for (int z = -radius; z <= radius + 1; ++z) {
                int x1East = x - 1;
                int z1North = z - 1;
                if (x * x + z * z > rSquared && x1East * x1East + z1North * z1North > rSquared && x * x + z1North * z1North > rSquared && x1East * x1East + z * z > rSquared) continue;
                this.setLeaves(worldIn, pos.func_177982_a(x, 0, z));
            }
        }
    }

    protected void addLeafLayer(World worldIn, BlockPos pos, int radius) {
        int rSquared = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > rSquared) continue;
                this.setLeaves(worldIn, pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        world.func_180495_p(pos).func_177230_c().onPlantGrow(world.func_180495_p(pos), world, pos, source);
    }
}

