/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.translation.I18n;

public abstract class SidedInventory
implements ISidedInventory {
    protected ItemStack[] slots;
    public String name;
    public final int stackLimit;
    public final TileEntity tile;

    public SidedInventory(TileEntity tile, String name, int slotsNum) {
        this(tile, name, slotsNum, 64);
    }

    public SidedInventory(TileEntity tile, String name, int slotsNum, int stackLimit) {
        this.tile = tile;
        this.name = name;
        this.slots = new ItemStack[slotsNum];
        this.stackLimit = stackLimit;
    }

    public ItemStack getSlot(int i) {
        return this.slots[i];
    }

    public void setSlot(int i, ItemStack stack) {
        this.slots[i] = stack;
    }

    public String func_70005_c_() {
        String langFileName = "tile." + this.tile.func_145838_q().func_149739_a().substring(5) + ".name";
        return this.func_145818_k_() ? this.name : I18n.func_74838_a((String)langFileName);
    }

    public boolean func_145818_k_() {
        return this.name != null && this.name.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.slots[index] != null) {
            if (this.slots[index].field_77994_a <= count) {
                ItemStack itemstack = this.slots[index];
                this.slots[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[index].func_77979_a(count);
            if (this.slots[index].field_77994_a == 0) {
                this.slots[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack itemstack = this.slots[index];
            this.slots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.slots[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v()) != this.tile ? false : player.func_174818_b(this.tile.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public ItemStack[] getSlots() {
        return this.slots;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.readItems(nbt);
        this.readName(nbt);
    }

    private void readItems(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = tagList.func_150305_b(i);
            byte b = nbt1.func_74771_c("Slot");
            if (b < 0 || b >= this.slots.length) continue;
            this.slots[b] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    private void readName(NBTTagCompound nbt) {
        if (nbt.func_150297_b("CustomName", 8)) {
            this.name = nbt.func_74779_i("CustomName");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.writeItems(nbt);
        this.writeName(nbt);
    }

    private void writeItems(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            tagList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("Items", (NBTBase)tagList);
    }

    private void writeName(NBTTagCompound nbt) {
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.name);
        }
    }
}

