/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity.fim;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import tinker_io.TileEntity.fim.Adapter;

public class SCTileAdapter
implements Adapter {
    public static final String ITEM_TEMP = "itemTemperatures";
    public static final String ITEM_TEMP_REQ = "itemTempRequired";
    private final TileSmeltery tile;

    public SCTileAdapter(TileSmeltery tile) {
        this.tile = tile;
    }

    @Override
    public int getFuelTemp() {
        FluidStack fluid;
        if (this.tile.currentFuel != null && (fluid = this.tile.currentFuel.copy()) != null) {
            return fluid.getFluid().getTemperature() - 300;
        }
        return 0;
    }

    @Override
    public boolean isAllItemFinishHeating() {
        int size = this.tile.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            if (!this.canFillIntoWhenFinishHeating(i)) continue;
            return false;
        }
        return true;
    }

    private boolean canFillIntoWhenFinishHeating(int index) {
        return this.getItemTemp(index) <= this.getItemTempRequire(index);
    }

    @Override
    public boolean isStructureActive() {
        return this.tile.isActive();
    }

    @Override
    public boolean isHeatingItem() {
        int[] temps;
        for (int x : temps = this.getItemTemps()) {
            if (x <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canFuelTempHeatThisItem(int index) {
        return this.tile.canHeat(index);
    }

    private int getItemTemp(int index) {
        int[] temps = this.getItemTemps();
        if (index > temps.length) {
            return 0;
        }
        return temps[index];
    }

    private int getItemTempRequire(int index) {
        int[] requires = this.getItemTempRequires();
        if (index > requires.length) {
            return 0;
        }
        return requires[index];
    }

    private ArrayList<Integer> getItemTempList() {
        int[] temps = this.getItemTemps();
        return new ArrayList<Integer>(Arrays.asList(new int[][]{temps}));
    }

    private ArrayList<Integer> getItemTempRequireList() {
        int[] requires = this.getItemTempRequires();
        return new ArrayList<Integer>(Arrays.asList(new int[][]{requires}));
    }

    private int[] getItemTemps() {
        return this.getNBT().func_74759_k(ITEM_TEMP);
    }

    private int[] getItemTempRequires() {
        return this.getNBT().func_74759_k(ITEM_TEMP_REQ);
    }

    private NBTTagCompound getNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tile.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public BlockPos getPos() {
        return this.tile.func_174877_v();
    }
}

