/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import tinker_io.TileEntity.SOTileEntity;
import tinker_io.inventory.ContainerSO;
import tinker_io.packet.PacketDispatcher;
import tinker_io.packet.VoidLiquidPacket;

public class SOGui
extends GuiContainer {
    private static final ResourceLocation SOGuiTextures = new ResourceLocation("tinker_io", "textures/gui/SmartOutput.png");
    private SOTileEntity tileSO;
    InventoryPlayer invPlayer2 = null;
    static GuiButton btn0;
    private static Map<Fluid, List<FluidGuiEntry>> fluidGui;

    public void func_73866_w_() {
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        super.func_73866_w_();
        btn0 = new GuiButton(0, k - 20, l + this.field_147000_g - 150, 20, 20, "");
        this.field_146292_n.add(btn0);
    }

    public SOGui(InventoryPlayer invPlayer, SOTileEntity tile) {
        super((Container)new ContainerSO(invPlayer, tile));
        this.invPlayer2 = invPlayer;
        this.tileSO = tile;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(SOGuiTextures);
        btn0.func_73729_b(-20, 15, 178, 82, 20, 20);
        String string = this.tileSO.func_145818_k_() ? this.tileSO.func_70005_c_() : I18n.func_135052_a((String)this.tileSO.func_70005_c_(), (Object[])new Object[0]);
        int outputSize = this.tileSO.getOutputSize();
        this.field_146289_q.func_78276_b(string, (this.field_146999_f - this.field_146289_q.func_78256_a(string)) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 94, 0x404040);
        this.field_146289_q.func_78276_b(TextFormatting.DARK_GREEN + "Max : " + outputSize, 120, 17, 0x404040);
        FluidTankInfo info = this.tileSO.getInfo();
        FluidStack liquid = info.fluid;
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        if (liquid != null) {
            ArrayList text = Lists.newArrayList();
            text.add(TextFormatting.WHITE.toString() + liquid.getLocalizedName());
            this.liquidToString(liquid, text);
            if (mouseX >= cornerX + 26 && mouseX <= cornerX + 38 && mouseY <= cornerY + 67 && mouseY >= cornerY + 67 - 52) {
                this.func_146283_a(text, mouseX - cornerX, mouseY - cornerY);
            }
        }
        if (btn0.func_146115_a()) {
            String[] desc = new String[]{TextFormatting.RED + I18n.func_135052_a((String)"tio.gui.SO.toolTips.button_head", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"tio.gui.SO.toolTips.button_info", (Object[])new Object[0])};
            List<String> temp = Arrays.asList(desc);
            this.drawHoveringText(temp, mouseX - cornerX + 10, mouseY - cornerY + 10, this.field_146289_q);
        }
    }

    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        FluidTankInfo info = this.tileSO.getInfo();
        FluidStack liquid = info.fluid;
        int cornerX = (this.field_146294_l - this.field_146999_f) / 2;
        int cornerY = (this.field_146295_m - this.field_147000_g) / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(SOGuiTextures);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.tileSO.getFrozenProgressScaled(24);
        this.func_73729_b(k + 93, l + 33, 176, 0, i1 + 1, 17);
        boolean hasPower = this.tileSO.func_145831_w().func_175640_z(this.tileSO.func_174877_v());
        if (this.tileSO.hasRedstoneUPG()) {
            if (hasPower) {
                this.func_73729_b(k + 119, l + 55, 176, 18, 22, 20);
                this.func_73729_b(k + 92, l + 32, 176, 60, 26, 20);
            } else {
                this.func_73729_b(k + 120, l + 55, 177, 39, 21, 20);
            }
        }
        int liquidAmount = this.tileSO.getLiquidAmount(52);
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        if (liquid != null) {
            GuiUtil.renderTiledFluid((int)(cornerX + 26), (int)(cornerY + 15 + 52 - liquidAmount), (int)12, (int)liquidAmount, (float)this.field_73735_i, (FluidStack)liquid);
        }
        SOGui.btn0.field_146124_l = SOGui.func_146272_n();
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                int[] coord = new int[]{this.tileSO.func_174877_v().func_177958_n(), this.tileSO.func_174877_v().func_177956_o(), this.tileSO.func_174877_v().func_177952_p()};
                this.tileSO.voidLiquid();
                PacketDispatcher.sendToServer(new VoidLiquidPacket(coord));
                break;
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void liquidToString(FluidStack fluid, List<String> text) {
        int amount = fluid.amount;
        if (!Util.isShiftKeyDown()) {
            List<FluidGuiEntry> entries = fluidGui.get(fluid.getFluid());
            if (entries == null) {
                entries = this.calcFluidGuiEntries(fluid.getFluid());
                fluidGui.put(fluid.getFluid(), entries);
            }
            for (FluidGuiEntry entry : entries) {
                amount = this.calcLiquidText(amount, entry.amount, entry.getText(), text);
            }
        }
        amount = this.calcLiquidText(amount, 1000000, Util.translate((String)"gui.smeltery.liquid.kilobucket", (Object[])new Object[0]), text);
        amount = this.calcLiquidText(amount, 1000, Util.translate((String)"gui.smeltery.liquid.bucket", (Object[])new Object[0]), text);
        this.calcLiquidText(amount, 1, Util.translate((String)"gui.smeltery.liquid.millibucket", (Object[])new Object[0]), text);
    }

    private List<FluidGuiEntry> calcFluidGuiEntries(Fluid fluid) {
        CastingRecipe recipe;
        ArrayList list = Lists.newArrayList();
        for (ICastingRecipe irecipe : TinkerRegistry.getAllBasinCastingRecipes()) {
            if (!(irecipe instanceof CastingRecipe) || (recipe = (CastingRecipe)irecipe).getFluid().getFluid() != fluid || recipe.cast != null) continue;
            list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.block"));
        }
        for (ICastingRecipe irecipe : TinkerRegistry.getAllTableCastingRecipes()) {
            if (!(irecipe instanceof CastingRecipe) || (recipe = (CastingRecipe)irecipe).getFluid().getFluid() != fluid || recipe.cast == null) continue;
            if (recipe.cast.matches(new ItemStack[]{TinkerSmeltery.castNugget}) != null) {
                list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.nugget"));
            }
            if (recipe.cast.matches(new ItemStack[]{TinkerSmeltery.castIngot}) != null) {
                list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.ingot"));
            }
            if (recipe.cast.matches(new ItemStack[]{TinkerSmeltery.castGem}) == null) continue;
            list.add(new FluidGuiEntry(recipe.getFluid().amount, "gui.smeltery.liquid.gem"));
        }
        Collections.sort(list, new Comparator<FluidGuiEntry>(){

            @Override
            public int compare(FluidGuiEntry o1, FluidGuiEntry o2) {
                return o2.amount - o1.amount;
            }
        });
        return ImmutableList.copyOf((Collection)list);
    }

    private int calcLiquidText(int amount, int divider, String unit, List<String> text) {
        int full = amount / divider;
        if (full > 0) {
            text.add(String.format("%d %s%s", full, TextFormatting.GRAY, unit));
        }
        return amount % divider;
    }

    static {
        fluidGui = Maps.newHashMap();
    }

    private static class FluidGuiEntry {
        public final int amount;
        public final String unlocName;

        private FluidGuiEntry(int amount, String unlocName) {
            this.amount = amount;
            this.unlocName = unlocName;
        }

        public String getText() {
            return Util.translate((String)this.unlocName, (Object[])new Object[0]);
        }
    }
}

