/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.main;

import com.google.common.collect.ImmutableSet;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import tinker_io.packet.PacketDispatcher;
import tinker_io.plugins.waila.MainWaila;
import tinker_io.proxy.CommonProxy;
import tinker_io.registry.BlockRegistry;
import tinker_io.registry.FluidRegister;
import tinker_io.registry.ItemRegistry;
import tinker_io.registry.OreCrusherBanLiatRegistry;
import tinker_io.registry.RecipeRegistry;
import tinker_io.registry.SmelteryRecipeRegistry;
import tinker_io.registry.SoundEventRegistry;

@Mod(modid="tinker_io", version="release 2.3.6", name="Tinker I/O", dependencies="required-after:Forge@[12.18.1.2073,);required-after:tconstruct@[1.10.2-2.5.2,);after:JEI;after:Waila;", acceptedMinecraftVersions="[1.10.2,]")
public class Main {
    public static final String MODID = "tinker_io";
    public static final String VERSION = "release 2.3.6";
    public static final String Name = "Tinker I/O";
    @SidedProxy(modId="tinker_io", clientSide="tinker_io.proxy.ClientProxy", serverSide="tinker_io.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="tinker_io")
    public static Main instance;
    public static CreativeTabs TinkerIOTabs;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        FluidRegister.mainRegistry();
        BlockRegistry.mainRegistry();
        ItemRegistry.mainRegistry();
        SoundEventRegistry.registerSounds();
        PacketDispatcher.registerPackets();
        proxy.registerTileEntities();
        MainWaila.startPlugin();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.init(event);
        RecipeRegistry.mainRegistry();
        OreCrusherBanLiatRegistry.registry();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        proxy.registerNetworkStuff();
        SmelteryRecipeRegistry.registerMeltingCasting();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Block block : TinkerSmeltery.validSmelteryBlocks) {
            builder.add((Object)block);
        }
        builder.add((Object)BlockRegistry.fuelInputMachine);
        TinkerSmeltery.validSmelteryBlocks = builder.build();
    }

    static {
        TinkerIOTabs = new CreativeTabs("TinkerIO_Tabs"){

            public Item func_78016_d() {
                return TinkerTools.largePlate;
            }
        };
    }
}

