/*
 * Decompiled with CFR 0.152.
 */
package betterachievements.gui;

import betterachievements.api.components.achievement.ICustomTitle;
import betterachievements.api.util.ColourHelper;
import betterachievements.reference.Resources;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.AchievementPage;

public class GuiBetterAchievement
extends GuiAchievement {
    private Minecraft mc;
    private int width;
    private int height;
    private String achievementTitle;
    private String achievementDescription;
    private String achievementPageName;
    private Achievement theAchievement;
    private long notificationTime;
    private RenderItem renderItem;
    private boolean permanentNotification;
    private Queue<Achievement> queue;

    public GuiBetterAchievement(Minecraft mc) {
        super(mc);
        this.mc = mc;
        this.renderItem = mc.func_175599_af();
        this.queue = new LinkedList<Achievement>();
    }

    public void func_146256_a(Achievement achievement) {
        if (this.notificationTime == 0L || this.permanentNotification) {
            this.achievementTitle = achievement instanceof ICustomTitle ? ((ICustomTitle)achievement).getTitle() : I18n.func_135052_a((String)"achievement.get", (Object[])new Object[0]);
            this.achievementDescription = achievement.func_150951_e().func_150260_c();
            this.notificationTime = Minecraft.func_71386_F();
            this.theAchievement = achievement;
            AchievementPage page = this.getPageOfAchievement(achievement);
            this.achievementPageName = page != null ? page.getName() : "Minecraft";
            this.permanentNotification = false;
        } else {
            this.queue.add(achievement);
        }
    }

    public void func_146255_b(Achievement achievement) {
        this.achievementTitle = achievement.func_150951_e().func_150260_c();
        this.achievementDescription = achievement.func_75989_e();
        this.notificationTime = Minecraft.func_71386_F() + 2500L;
        this.theAchievement = achievement;
        this.permanentNotification = true;
    }

    private void updateAchievementWindowScale() {
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        this.width = this.mc.field_71443_c;
        this.height = this.mc.field_71440_d;
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        this.width = scaledresolution.func_78326_a();
        this.height = scaledresolution.func_78328_b();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void func_146254_a() {
        if (this.theAchievement != null && this.notificationTime != 0L && Minecraft.func_71410_x().field_71439_g != null) {
            double d0 = (double)(Minecraft.func_71386_F() - this.notificationTime) / (this.queue.isEmpty() ? 3000.0 : 2000.0);
            if (!this.permanentNotification) {
                if (d0 < 0.0 || d0 > 1.0) {
                    if (!this.queue.isEmpty()) {
                        Achievement achievement = this.queue.poll();
                        this.achievementTitle = I18n.func_135052_a((String)"achievement.get", (Object[])new Object[0]);
                        this.achievementDescription = achievement.func_150951_e().func_150260_c();
                        this.notificationTime = Minecraft.func_71386_F();
                        this.theAchievement = achievement;
                        AchievementPage page = this.getPageOfAchievement(achievement);
                        this.achievementPageName = page != null ? page.getName() : "Minecraft";
                        this.permanentNotification = false;
                    } else {
                        this.notificationTime = 0L;
                    }
                    return;
                }
            } else if (d0 > 0.5) {
                d0 = 0.5;
            }
            this.updateAchievementWindowScale();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            double d1 = d0 * 2.0;
            if (d1 > 1.0) {
                d1 = 2.0 - d1;
            }
            d1 *= 4.0;
            if ((d1 = 1.0 - d1) < 0.0) {
                d1 = 0.0;
            }
            d1 *= d1;
            d1 *= d1;
            int i = this.width - 160;
            int j = 0 - (int)(d1 * (this.permanentNotification ? 36.0 : 43.0));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            this.mc.func_110434_K().func_110577_a(Resources.GUI.SPRITES);
            GlStateManager.func_179140_f();
            if (this.permanentNotification) {
                this.func_73729_b(i, j, 96, 202, 160, 32);
                this.mc.field_71466_p.func_78279_b(this.achievementDescription, i + 30, j + 7, 120, -1);
            } else {
                this.func_73729_b(i, j, 96, 202, 160, 28);
                this.func_73729_b(i, j + 28, 96, 207, 160, 11);
                this.func_73729_b(i, j + 39, 96, 230, 160, 4);
                this.mc.field_71466_p.func_78276_b(this.achievementTitle, i + 30, j + 7, -256);
                this.mc.field_71466_p.func_78276_b(this.achievementDescription, i + 30, j + 18, -1);
                String s = this.mc.field_71466_p.func_78256_a(this.achievementPageName) > 120 ? this.mc.field_71466_p.func_78269_a(this.achievementPageName, 120) + "..." : this.achievementPageName;
                this.mc.field_71466_p.func_78276_b(s, i + 30, j + 29, ColourHelper.RGB("#5555FF"));
            }
            RenderHelper.func_74520_c();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            GlStateManager.func_179145_e();
            this.renderItem.func_180450_b(this.theAchievement.field_75990_d, i + 8, j + (this.permanentNotification ? 8 : 14));
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
        }
    }

    public AchievementPage getPageOfAchievement(Achievement achievement) {
        for (AchievementPage page : AchievementPage.getAchievementPages()) {
            if (!page.getAchievements().contains(achievement)) continue;
            return page;
        }
        return null;
    }
}

