/*
 * Decompiled with CFR 0.152.
 */
package betterachievements.handler;

import betterachievements.handler.ConfigHandler;
import betterachievements.util.LogHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AchievementHandler {
    private final Map<UUID, Set<Achievement>> playerAchievementMap = new HashMap<UUID, Set<Achievement>>();
    private final Set<UUID> currentItrs = new HashSet<UUID>();
    private static final String FILENAME = "toUnlockAchievements.dat";
    private static AchievementHandler instance;

    public static AchievementHandler getInstance() {
        if (instance == null) {
            instance = new AchievementHandler();
        }
        return instance;
    }

    private AchievementHandler() {
    }

    @SubscribeEvent
    public void onAchievementUnlocked(AchievementEvent event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            StatisticsManagerServer stats = ((EntityPlayerMP)event.getEntityPlayer()).func_147099_x();
            if (stats.func_77442_b(event.getAchievement())) {
                stats.func_150873_a(event.getEntityPlayer(), (StatBase)event.getAchievement(), 1);
                event.setCanceled(true);
            } else {
                this.addAchievementToMap(event.getEntityPlayer().func_110124_au(), event.getAchievement());
            }
            if (!this.currentItrs.contains(event.getEntityPlayer().func_110124_au())) {
                this.tryUnlock((EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    public void addAchievementToMap(UUID uuid, Achievement achievement) {
        Set<Achievement> achievements = this.playerAchievementMap.get(uuid);
        if (achievements == null) {
            achievements = new HashSet<Achievement>();
        }
        achievements.add(achievement);
        this.playerAchievementMap.put(uuid, achievements);
    }

    public void tryUnlock(EntityPlayerMP player) {
        boolean doItr;
        this.currentItrs.add(player.func_110124_au());
        Set<Achievement> achievements = this.playerAchievementMap.get(player.func_110124_au());
        boolean bl = doItr = achievements != null;
        while (doItr) {
            doItr = false;
            Iterator<Achievement> itr = achievements.iterator();
            while (itr.hasNext()) {
                Achievement current = itr.next();
                if (!player.func_147099_x().func_77442_b(current)) continue;
                player.func_71029_a((StatBase)current);
                itr.remove();
                doItr = true;
            }
        }
        this.currentItrs.remove(player.func_110124_au());
    }

    public void dumpAchievementData(String worldName) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Map.Entry<UUID, Set<Achievement>> entry : this.playerAchievementMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getKey().toString()).append("->");
            for (Achievement achievement : entry.getValue()) {
                sb.append(achievement.field_75975_e).append(",");
            }
            lines.add(sb.toString());
        }
        try {
            Files.write(new File(ConfigHandler.getConfigDir(), worldName.replaceAll("[^a-zA-Z0-9.-]", "_") + " " + FILENAME).toPath(), lines, Charset.defaultCharset(), new OpenOption[0]);
        }
        catch (IOException e) {
            LogHelper.instance().error(e, "couldn't write " + worldName + " " + FILENAME);
        }
    }

    public void constructFromData(String worldName) {
        this.playerAchievementMap.clear();
        HashMap<String, Achievement> achievementMap = new HashMap<String, Achievement>();
        for (Achievement achievement : AchievementList.field_187981_e) {
            achievementMap.put(achievement.field_75975_e, achievement);
        }
        try {
            File file = new File(ConfigHandler.getConfigDir(), worldName.replaceAll("[^a-zA-Z0-9.-]", "_") + " " + FILENAME);
            if (!file.exists()) {
                return;
            }
            List<String> lines = Files.readAllLines(file.toPath(), Charset.defaultCharset());
            for (String line : lines) {
                UUID uuid;
                String[] splitted = line.split("->");
                if (splitted.length != 2) continue;
                try {
                    uuid = UUID.fromString(splitted[0]);
                }
                catch (IllegalArgumentException e) {
                    LogHelper.instance().error(e, "bad uuid \"" + splitted[0] + "\" in " + worldName + " " + FILENAME);
                    continue;
                }
                HashSet<Achievement> achievementSet = new HashSet<Achievement>();
                for (String sAchievement : splitted[1].split(",")) {
                    Achievement achievement = (Achievement)achievementMap.get(sAchievement);
                    if (achievement == null) continue;
                    achievementSet.add(achievement);
                }
                this.playerAchievementMap.put(uuid, achievementSet);
            }
        }
        catch (IOException e) {
            LogHelper.instance().error(e, "couldn't read " + worldName + " " + FILENAME);
        }
    }
}

