/*
 * Decompiled with CFR 0.152.
 */
package betterachievements.handler;

import betterachievements.api.util.ColourHelper;
import betterachievements.gui.GuiBetterAchievements;
import betterachievements.handler.SaveHandler;
import betterachievements.handler.message.AchievementLockUnlockMessage;
import betterachievements.registry.AchievementRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    private static File configDir;

    public static void init() {
        if (config == null) {
            config = new Configuration(new File(configDir, "BetterAchievements.cfg"));
            ConfigHandler.loadConfig();
        }
    }

    public static void initConfigDir(File configDir) {
        configDir = new File(configDir, "BetterAchievements");
        configDir.mkdir();
        ConfigHandler.configDir = configDir;
    }

    public static File getConfigDir() {
        return configDir;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("BetterAchievements")) {
            ConfigHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        Property prop = config.get("general", "scrollButtons", true);
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.scrollButtons.desc"));
        prop.setLanguageKey("betterachievements.config.scrollButtons");
        GuiBetterAchievements.scrollButtons = prop.getBoolean();
        prop = config.get("general", "opLockUnlock", true);
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.opLockUnlock.desc"));
        prop.setLanguageKey("betterachievements.config.opLockUnlock");
        AchievementLockUnlockMessage.Handler.opLockUnlock = prop.getBoolean();
        prop = config.get("general", "cantUnlockArrowColour", "#000000");
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.cantUnlockArrowColour.desc"));
        prop.setLanguageKey("betterachievements.config.cantUnlockArrowColour");
        String colourCode = prop.getString();
        if (colourCode.startsWith("#")) {
            GuiBetterAchievements.colourCantUnlockRainbow = false;
            GuiBetterAchievements.colourCantUnlock = ColourHelper.RGB(colourCode);
        } else if (colourCode.startsWith("rainbow")) {
            GuiBetterAchievements.colourCantUnlockRainbow = true;
            GuiBetterAchievements.colourCantUnlockRainbowSettings = ColourHelper.getRainbowSettings(colourCode);
        }
        prop = config.get("general", "canUnlockArrowColour", "#00FF00");
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.canUnlockArrowColour.desc"));
        prop.setLanguageKey("betterachievements.config.canUnlockArrowColour");
        colourCode = prop.getString();
        if (colourCode.startsWith("#")) {
            GuiBetterAchievements.colourCanUnlockRainbow = false;
            GuiBetterAchievements.colourCanUnlock = ColourHelper.RGB(colourCode);
        } else if (colourCode.startsWith("rainbow")) {
            GuiBetterAchievements.colourCanUnlockRainbow = true;
            GuiBetterAchievements.colourCanUnlockRainbowSettings = ColourHelper.getRainbowSettings(colourCode);
        }
        prop = config.get("general", "completeArrowColour", "#A0A0A0");
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.completeArrowColour.desc"));
        prop.setLanguageKey("betterachievements.config.completeArrowColour");
        colourCode = prop.getString();
        if (colourCode.startsWith("#")) {
            GuiBetterAchievements.colourUnlockedRainbow = false;
            GuiBetterAchievements.colourUnlocked = ColourHelper.RGB(colourCode);
        } else if (colourCode.startsWith("rainbow")) {
            GuiBetterAchievements.colourUnlockedRainbow = true;
            GuiBetterAchievements.colourUnlockedRainbowSettings = ColourHelper.getRainbowSettings(colourCode);
        }
        prop = config.get("general", "userColourOverride", false);
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.userColourOverride.desc"));
        prop.setLanguageKey("betterachievements.config.userColourOverride");
        GuiBetterAchievements.userColourOverride = prop.getBoolean();
        prop = config.get("general", "iconReset", false);
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.iconReset.desc"));
        prop.setLanguageKey("betterachievements.config.iconReset");
        GuiBetterAchievements.iconReset = prop.getBoolean();
        prop = config.get("general", "listTabIcons", new String[0]);
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.listTabIcons.desc"));
        prop.setLanguageKey("betterachievements.config.listTabIcons");
        SaveHandler.userSetIcons = prop.getStringList();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void saveUserSetIcons() {
        SaveHandler.userSetIcons = AchievementRegistry.instance().dumpUserSetIcons();
        Property prop = config.get("general", "listTabIcons", new String[0]);
        prop.setComment(I18n.func_74838_a((String)"betterachievements.config.listTabIcons.desc"));
        prop.setLanguageKey("betterachievements.config.listTabIcons");
        prop.set(SaveHandler.userSetIcons);
        config.save();
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        return list;
    }
}

