/*
 * Decompiled with CFR 0.152.
 */
package betterachievements.handler.message;

import betterachievements.registry.AchievementRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AchievementLockUnlockMessage
implements IMessage {
    private String achievementId;
    private boolean lockUnlock;

    public AchievementLockUnlockMessage() {
    }

    public AchievementLockUnlockMessage(Achievement achievement, boolean lockUnlock) {
        this.achievementId = achievement.field_75975_e;
        this.lockUnlock = lockUnlock;
    }

    public void fromBytes(ByteBuf buf) {
        this.lockUnlock = buf.readBoolean();
        int length = buf.readInt();
        this.achievementId = new String(buf.readBytes(length).array());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.lockUnlock);
        byte[] bytes = this.achievementId.getBytes();
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    public static class Handler
    implements IMessageHandler<AchievementLockUnlockMessage, IMessage> {
        public static boolean opLockUnlock = true;

        public IMessage onMessage(AchievementLockUnlockMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.onServerMessage(message, ctx));
            return null;
        }

        public void onServerMessage(AchievementLockUnlockMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (this.canLockUnlock(player)) {
                Achievement achievement = AchievementRegistry.instance().getAchievement(message.achievementId);
                if (message.lockUnlock) {
                    this.unlockAchievement(achievement, player);
                } else {
                    this.lockAchievement(achievement, player);
                }
            }
        }

        private void unlockAchievement(Achievement achievement, EntityPlayerMP player) {
            Stack<Achievement> stack = new Stack<Achievement>();
            stack.push(achievement);
            while (achievement.field_75992_c != null && !player.func_147099_x().func_77443_a(achievement.field_75992_c)) {
                stack.push(achievement.field_75992_c);
                achievement = achievement.field_75992_c;
            }
            while (!stack.isEmpty()) {
                player.func_71029_a((StatBase)stack.pop());
            }
        }

        private void lockAchievement(Achievement achievement, EntityPlayerMP player) {
            AchievementRegistry.instance().getAllChildren(achievement).forEach(arg_0 -> ((EntityPlayerMP)player).func_175145_a(arg_0));
        }

        private boolean canLockUnlock(EntityPlayerMP player) {
            if (opLockUnlock) {
                return player.func_184102_h() != null && player.func_184102_h().func_184103_al().func_152596_g(player.func_146103_bH());
            }
            return player.func_184812_l_();
        }
    }
}

