/*
 * Decompiled with CFR 0.152.
 */
package betterachievements.registry;

import betterachievements.api.components.page.ICustomIcon;
import betterachievements.util.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.AchievementPage;

public final class AchievementRegistry {
    private static AchievementRegistry instance;
    public static final AchievementPage mcPage;
    private List<Achievement> mcAchievements = new LinkedList<Achievement>();
    private Map<String, Achievement> statIdMap;
    private Map<String, ItemStack> iconMap = new LinkedHashMap<String, ItemStack>();
    private Map<String, ItemStack> userSetIcons;
    private Map<String, List<String>> childernMap;
    private boolean firstLoad = true;

    public static AchievementRegistry instance() {
        if (instance == null) {
            instance = new AchievementRegistry();
        }
        return instance;
    }

    private AchievementRegistry() {
        this.statIdMap = new LinkedHashMap<String, Achievement>();
        this.userSetIcons = new LinkedHashMap<String, ItemStack>();
        this.childernMap = new LinkedHashMap<String, List<String>>();
    }

    private void init() {
        for (Achievement achievement : AchievementList.field_187981_e) {
            this.statIdMap.put(achievement.field_75975_e, achievement);
            if (!AchievementPage.isAchievementInPages((Achievement)achievement)) {
                this.mcAchievements.add(achievement);
            }
            if (achievement.field_75992_c == null) continue;
            List<String> children = this.childernMap.get(achievement.field_75992_c.field_75975_e);
            if (children == null) {
                children = new LinkedList<String>();
            }
            children.add(achievement.field_75975_e);
            this.childernMap.put(achievement.field_75992_c.field_75975_e, children);
        }
        this.iconMap.put(mcPage.getName(), new ItemStack((Block)Blocks.field_150349_c));
        this.iconMap.putAll(this.userSetIcons);
        this.firstLoad = false;
    }

    public List<Achievement> getAchievements(AchievementPage page) {
        if (this.firstLoad) {
            this.init();
        }
        return page == mcPage ? this.mcAchievements : page.getAchievements();
    }

    public List<AchievementPage> getAllPages() {
        if (this.firstLoad) {
            this.init();
        }
        LinkedList<AchievementPage> pages = new LinkedList<AchievementPage>();
        pages.add(mcPage);
        int size = AchievementPage.getAchievementPages().size();
        for (int i = 0; i < size; ++i) {
            pages.add(AchievementPage.getAchievementPage((int)i));
        }
        return pages;
    }

    public ItemStack getItemStack(AchievementPage page) {
        if (page == null) {
            return null;
        }
        ItemStack itemStack = this.iconMap.get(page.getName());
        if (itemStack == null) {
            if (page instanceof ICustomIcon) {
                itemStack = ((ICustomIcon)page).getPageIcon();
            }
            if (itemStack == null) {
                for (Achievement achievement : page.getAchievements()) {
                    if (achievement.field_75992_c != null) continue;
                    itemStack = achievement.field_75990_d;
                    break;
                }
                if (itemStack == null && page.getAchievements().size() > 0) {
                    itemStack = ((Achievement)page.getAchievements().get((int)0)).field_75990_d;
                }
                this.iconMap.put(page.getName(), itemStack);
            }
        }
        return itemStack;
    }

    public void registerIcon(String pageName, ItemStack itemStack, boolean userSet) {
        this.iconMap.put(pageName, itemStack);
        if (userSet) {
            this.userSetIcons.put(pageName, itemStack);
        }
    }

    public Achievement getAchievement(String statId) {
        if (this.firstLoad) {
            this.init();
        }
        return this.statIdMap.get(statId);
    }

    public List<Achievement> getAllChildren(Achievement achievement) {
        return this.toAchievements(this.getAllChildren(achievement.field_75975_e));
    }

    public List<String> getAllChildren(String statId) {
        LinkedList<String> children = new LinkedList<String>();
        List<String> directChildren = this.getDirectChildren(statId);
        while (!directChildren.isEmpty()) {
            children.addAll(directChildren);
            directChildren = directChildren.stream().map(this::getDirectChildren).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return children;
    }

    public List<Achievement> getDirectChildren(Achievement achievement) {
        return this.toAchievements(this.getDirectChildren(achievement.field_75975_e));
    }

    public List<String> getDirectChildren(String statId) {
        if (this.firstLoad) {
            this.init();
        }
        return this.childernMap.containsKey(statId) ? this.childernMap.get(statId) : new ArrayList<String>();
    }

    public List<Achievement> toAchievements(List<String> statIds) {
        return statIds.stream().map(this::getAchievement).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String[] dumpUserSetIcons() {
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, ItemStack> entry : this.userSetIcons.entrySet()) {
            String pageName = entry.getKey();
            ItemStack itemStack = entry.getValue();
            String itemName = itemStack.func_77973_b().getRegistryName().toString();
            String nbtCompoundTag = itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "";
            list.add(pageName + "->" + itemName + ":" + entry.getValue().func_77952_i() + ":" + nbtCompoundTag);
        }
        return list.toArray(new String[list.size()]);
    }

    public void setUserSetIcons(String[] array) {
        int i = 0;
        for (String entry : array) {
            String[] itemSplit;
            String[] split = entry.split("->");
            if (split.length != 2 || (itemSplit = split[1].split(":", 4)).length < 2) continue;
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemSplit[0], itemSplit[1]));
            int meta = 0;
            try {
                meta = itemSplit.length > 2 ? Integer.parseInt(itemSplit[2]) : 0;
            }
            catch (NumberFormatException e) {
                LogHelper.instance().error(e, "Invalid input for meta data on entry " + i);
            }
            NBTTagCompound nbtTag = null;
            try {
                nbtTag = itemSplit.length > 3 && !itemSplit[3].equals("") ? JsonToNBT.func_180713_a((String)itemSplit[3]) : null;
            }
            catch (NBTException e) {
                LogHelper.instance().error((Exception)((Object)e), "Invalid input for nbt data on entry " + i);
            }
            ItemStack itemStack = null;
            if (item != null) {
                itemStack = new ItemStack(item, 0, meta);
            }
            if (itemStack != null) {
                if (nbtTag != null) {
                    itemStack.func_77982_d(nbtTag);
                }
                this.userSetIcons.put(split[0], itemStack);
            }
            ++i;
        }
    }

    static {
        mcPage = new AchievementPage("Minecraft", new Achievement[0]);
    }
}

