/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks;

import com.pam.harvestcraft.blocks.blocks.ApiaryBlock;
import com.pam.harvestcraft.blocks.blocks.BeehiveBlock;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import com.pam.harvestcraft.blocks.blocks.BlockPamCake;
import com.pam.harvestcraft.blocks.blocks.BlockPamMarket;
import com.pam.harvestcraft.blocks.blocks.GroundTrapBlock;
import com.pam.harvestcraft.blocks.blocks.PresserBlock;
import com.pam.harvestcraft.blocks.blocks.WaterTrapBlock;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public final class BlockRegistry {
    public static final String marketItemName = "market";
    public static Block pamMarket;
    public static ItemBlock marketItemBlock;
    public static GroundTrapBlock groundtrap;
    public static ItemBlock groundtrapItemBlock;
    public static WaterTrapBlock watertrap;
    public static ItemBlock watertrapItemBlock;
    public static BeehiveBlock beehive;
    public static ItemBlock beehiveItemBlock;
    public static ApiaryBlock apiary;
    public static ItemBlock apiaryItemBlock;
    public static PresserBlock presser;
    public static ItemBlock presserItemBlock;
    public static BlockPamCake carrotcake;
    public static ItemBlock carrotcakeItemBlock;
    public static BlockPamCake cheesecake;
    public static ItemBlock cheesecakeItemBlock;
    public static BlockPamCake cherrycheesecake;
    public static ItemBlock cherrycheesecakeItemBlock;
    public static BlockPamCake chocolatesprinklecake;
    public static ItemBlock chocolatesprinklecakeItemBlock;
    public static BlockPamCake holidaycake;
    public static ItemBlock holidaycakeItemBlock;
    public static BlockPamCake lamingtoncake;
    public static ItemBlock lamingtoncakeItemBlock;
    public static BlockPamCake pavlovacake;
    public static ItemBlock pavlovacakeItemBlock;
    public static BlockPamCake pineappleupsidedowncake;
    public static ItemBlock pineappleupsidedowncakeItemBlock;
    public static BlockPamCake pumpkincheesecake;
    public static ItemBlock pumpkincheesecakeItemBlock;
    public static BlockPamCake redvelvetcake;
    public static ItemBlock redvelvetcakeItemBlock;
    public static final HashMap<String, BlockBaseGarden> gardens;
    public static final String aridGarden = "aridGarden";
    public static final String frostGarden = "frostGarden";
    public static final String tropicalGarden = "tropicalGarden";
    public static final String windyGarden = "windyGarden";
    public static final String shadedGarden = "shadedGarden";
    public static final String soggyGarden = "soggyGarden";
    private static boolean initialized;

    public static void initBlockRegistry() {
        BlockRegistry.registerMarket();
        BlockRegistry.registerTraps();
        BlockRegistry.registerBeeFeatures();
        BlockRegistry.registerGardens();
        BlockRegistry.registerPresser();
        BlockRegistry.registerCakes();
        initialized = true;
    }

    public static BlockBaseGarden getGarden(String gardenName) {
        if (!initialized) {
            FMLLog.bigWarning((String)"BlockRegistry has not been initialized yet.", (Object[])new Object[0]);
            return null;
        }
        if (!gardens.containsKey(gardenName)) {
            FMLLog.bigWarning((String)"Garden %s is not registered.", (Object[])new Object[]{gardenName});
            return null;
        }
        return gardens.get(gardenName);
    }

    private static void registerPresser() {
        presser = new PresserBlock();
        presserItemBlock = new ItemBlock((Block)presser);
        ItemRegistry.items.put("presser", (Item)presserItemBlock);
        BlockRegistry.registerBlock("presser", presserItemBlock, (Block)presser);
    }

    private static void registerBeeFeatures() {
        beehive = new BeehiveBlock();
        beehiveItemBlock = new ItemBlock((Block)beehive);
        ItemRegistry.items.put("beehive", (Item)beehiveItemBlock);
        BlockRegistry.registerBlock("beehive", beehiveItemBlock, beehive);
        apiary = new ApiaryBlock();
        apiaryItemBlock = new ItemBlock((Block)apiary);
        ItemRegistry.items.put("apiary", (Item)apiaryItemBlock);
        BlockRegistry.registerBlock("apiary", apiaryItemBlock, (Block)apiary);
    }

    private static void registerMarket() {
        pamMarket = new BlockPamMarket().func_149711_c(1.0f).func_149752_b(1.0f);
        marketItemBlock = new ItemBlock(pamMarket);
        ItemRegistry.items.put(marketItemName, (Item)marketItemBlock);
        BlockRegistry.registerBlock(marketItemName, marketItemBlock, pamMarket);
    }

    private static void registerTraps() {
        groundtrap = new GroundTrapBlock();
        groundtrapItemBlock = new ItemBlock((Block)groundtrap);
        ItemRegistry.items.put("groundtrap", (Item)groundtrapItemBlock);
        BlockRegistry.registerBlock("groundtrap", groundtrapItemBlock, (Block)groundtrap);
        watertrap = new WaterTrapBlock();
        watertrapItemBlock = new ItemBlock((Block)watertrap);
        ItemRegistry.items.put("watertrap", (Item)watertrapItemBlock);
        BlockRegistry.registerBlock("watertrap", watertrapItemBlock, (Block)watertrap);
    }

    private static void registerGardens() {
        BlockRegistry.addGarden(aridGarden, BlockBaseGarden.Region.DESERT);
        BlockRegistry.addGarden(frostGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(shadedGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(soggyGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(tropicalGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(windyGarden, BlockBaseGarden.Region.PLAINS);
    }

    private static void registerCakes() {
        String carrotcakeName = "carrotcake";
        String cheesecakeName = "cheesecake";
        String cherrycheesecakeName = "cherrycheesecake";
        String chocolatesprinklecakeName = "chocolatesprinklecake";
        String holidaycakeName = "holidaycake";
        String lamingtoncakeName = "lamingtoncake";
        String pavlovacakeName = "pavlovacake";
        String pineappleupsidedowncakeName = "pineappleupsidedowncake";
        String pumpkincheesecakeName = "pumpkincheesecake";
        String redvelvetcakeName = "redvelvetcake";
        carrotcake = new BlockPamCake(4);
        carrotcakeItemBlock = new ItemBlock((Block)carrotcake);
        ItemRegistry.items.put("carrotcake", (Item)carrotcakeItemBlock);
        BlockRegistry.registerBlock("carrotcake", carrotcakeItemBlock, carrotcake);
        cheesecake = new BlockPamCake(5);
        cheesecakeItemBlock = new ItemBlock((Block)cheesecake);
        ItemRegistry.items.put("cheesecake", (Item)cheesecakeItemBlock);
        BlockRegistry.registerBlock("cheesecake", cheesecakeItemBlock, cheesecake);
        cherrycheesecake = new BlockPamCake(6);
        cherrycheesecakeItemBlock = new ItemBlock((Block)cherrycheesecake);
        ItemRegistry.items.put("cherrycheesecake", (Item)cherrycheesecakeItemBlock);
        BlockRegistry.registerBlock("cherrycheesecake", cherrycheesecakeItemBlock, cherrycheesecake);
        chocolatesprinklecake = new BlockPamCake(4);
        chocolatesprinklecakeItemBlock = new ItemBlock((Block)chocolatesprinklecake);
        ItemRegistry.items.put("chocolatesprinklecake", (Item)chocolatesprinklecakeItemBlock);
        BlockRegistry.registerBlock("chocolatesprinklecake", chocolatesprinklecakeItemBlock, chocolatesprinklecake);
        holidaycake = new BlockPamCake(5);
        holidaycakeItemBlock = new ItemBlock((Block)holidaycake);
        ItemRegistry.items.put("holidaycake", (Item)holidaycakeItemBlock);
        BlockRegistry.registerBlock("holidaycake", holidaycakeItemBlock, holidaycake);
        lamingtoncake = new BlockPamCake(3);
        lamingtoncakeItemBlock = new ItemBlock((Block)lamingtoncake);
        ItemRegistry.items.put("lamingtoncake", (Item)lamingtoncakeItemBlock);
        BlockRegistry.registerBlock("lamingtoncake", lamingtoncakeItemBlock, lamingtoncake);
        pavlovacake = new BlockPamCake(5);
        pavlovacakeItemBlock = new ItemBlock((Block)pavlovacake);
        ItemRegistry.items.put("pavlovacake", (Item)pavlovacakeItemBlock);
        BlockRegistry.registerBlock("pavlovacake", pavlovacakeItemBlock, pavlovacake);
        pineappleupsidedowncake = new BlockPamCake(5);
        pineappleupsidedowncakeItemBlock = new ItemBlock((Block)pineappleupsidedowncake);
        ItemRegistry.items.put("pineappleupsidedowncake", (Item)pineappleupsidedowncakeItemBlock);
        BlockRegistry.registerBlock("pineappleupsidedowncake", pineappleupsidedowncakeItemBlock, pineappleupsidedowncake);
        pumpkincheesecake = new BlockPamCake(4);
        pumpkincheesecakeItemBlock = new ItemBlock((Block)pumpkincheesecake);
        ItemRegistry.items.put("pumpkincheesecake", (Item)pumpkincheesecakeItemBlock);
        BlockRegistry.registerBlock("pumpkincheesecake", pumpkincheesecakeItemBlock, pumpkincheesecake);
        redvelvetcake = new BlockPamCake(6);
        redvelvetcakeItemBlock = new ItemBlock((Block)redvelvetcake);
        ItemRegistry.items.put("redvelvetcake", (Item)redvelvetcakeItemBlock);
        BlockRegistry.registerBlock("redvelvetcake", redvelvetcakeItemBlock, redvelvetcake);
    }

    private static void addGarden(String gardenName, BlockBaseGarden.Region region) {
        BlockBaseGarden garden = new BlockBaseGarden(gardenName, region);
        gardens.put(gardenName, garden);
    }

    public static void registerBlock(String registerName, ItemBlock itemBlock, Block block) {
        block.setRegistryName(registerName);
        block.func_149663_c(registerName);
        GameRegistry.register((IForgeRegistryEntry)block);
        itemBlock.setRegistryName(registerName);
        itemBlock.func_77655_b(registerName);
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
    }

    public static void registerBlock(String registerName, Block block) {
        ItemBlock itemBlock = new ItemBlock(block);
        BlockRegistry.registerBlock(registerName, itemBlock, block);
    }

    static {
        gardens = new HashMap();
        initialized = false;
    }
}

