/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks.growables;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.worldgen.FruitTreeGen;
import com.pam.harvestcraft.worldgen.LogFruitTreeGen;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.FMLLog;

public class BlockPamSapling
extends BlockBush
implements IGrowable {
    public final String name;
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private Block fruit;
    private Item fruitItem;
    private final SaplingType saplingType;
    private final BlockPlanks.EnumType planks;
    private final int rarity;
    private final IBlockState logState;
    private final IBlockState leavesState;

    public BlockPamSapling(String name, SaplingType saplingType) {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149647_a(HarvestCraft.modTab);
        this.saplingType = saplingType;
        this.name = name;
        switch (saplingType) {
            case WARM: {
                this.planks = BlockPlanks.EnumType.JUNGLE;
                this.rarity = HarvestCraft.config.tropicalfruittreeRarity;
                break;
            }
            case COLD: {
                this.planks = BlockPlanks.EnumType.SPRUCE;
                this.rarity = HarvestCraft.config.coniferousfruittreeRarity;
                break;
            }
            default: {
                this.planks = BlockPlanks.EnumType.OAK;
                this.rarity = HarvestCraft.config.temperatefruittreeRarity;
            }
        }
        this.logState = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)this.planks);
        this.leavesState = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)this.planks).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public String getName() {
        return this.name;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Block soilBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return this.isSuitableSoilBlock(soilBlock);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.validatePosition(worldIn, pos, state);
    }

    private void validatePosition(World world, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean isSuitableSoilBlock(Block soilBlock) {
        return soilBlock == Blocks.field_150349_c || soilBlock == Blocks.field_150346_d || soilBlock == Blocks.field_150458_ak;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    private void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.generateTree(worldIn, pos, state, rand);
    }

    private void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        worldIn.func_175698_g(pos);
        IBlockState fruitState = this.getFruit().func_176223_P();
        if (this.getFruit() instanceof BlockPamFruit) {
            if (!new FruitTreeGen(5, this.logState, this.leavesState, false, fruitState).func_180709_b(worldIn, rand, pos)) {
                worldIn.func_175656_a(pos, state);
            }
        } else if (this.getFruit() instanceof BlockPamFruitLog && !new LogFruitTreeGen(5, this.logState, this.leavesState, fruitState).func_180709_b(worldIn, rand, pos)) {
            worldIn.func_175656_a(pos, state);
        }
    }

    public void worldGenTrees(World world, BlockPos pos) {
        for (int tries = 0; tries < this.rarity; ++tries) {
            int posX = pos.func_177958_n() + world.field_73012_v.nextInt(8) - world.field_73012_v.nextInt(8);
            int posY = pos.func_177956_o() + world.field_73012_v.nextInt(4) - world.field_73012_v.nextInt(4);
            int posZ = pos.func_177952_p() + world.field_73012_v.nextInt(8) - world.field_73012_v.nextInt(8);
            BlockPos newPos = new BlockPos(posX, posY, posZ);
            IBlockState fruitState = this.getFruit().func_176223_P();
            if (this.getFruit() instanceof BlockPamFruit) {
                new FruitTreeGen(5, this.logState, this.leavesState, false, fruitState).func_180709_b(world, world.field_73012_v, newPos);
                continue;
            }
            if (!(this.getFruit() instanceof BlockPamFruitLog)) continue;
            new LogFruitTreeGen(5, this.logState, this.leavesState, fruitState).func_180709_b(world, world.field_73012_v, newPos);
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)rand.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public Item getFruitItem() {
        return this.fruitItem;
    }

    public void setFruit(@Nonnull Block fruit) {
        this.fruit = fruit;
        if (fruit instanceof BlockPamFruit) {
            this.fruitItem = ((BlockPamFruit)fruit).getFruitItem();
            return;
        }
        if (fruit instanceof BlockPamFruitLog) {
            this.fruitItem = ((BlockPamFruitLog)fruit).getFruitItem();
            return;
        }
        FMLLog.severe((String)"Given fruit block %s is invalid.", (Object[])new Object[]{fruit.func_149739_a()});
    }

    public Block getFruit() {
        if (this.fruit == null) {
            FMLLog.bigWarning((String)"Fruit for sapling %s not found.", (Object[])new Object[]{this.func_149739_a()});
            return null;
        }
        return this.fruit;
    }

    public static enum SaplingType {
        TEMPERATE,
        WARM,
        COLD;

    }
}

