/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ManualPageMultiblock
extends ManualPages {
    MultiblockHandler.IMultiblock multiblock;
    boolean canTick = true;
    boolean showCompleted = false;
    int tick = 0;
    int showLayer = -1;
    int blockCount = 0;
    int[] countPerLevel;
    int structureHeight = 0;
    int structureLength = 0;
    int structureWidth = 0;
    float rotX = 0.0f;
    float rotY = 0.0f;
    float rotZ = 0.0f;
    List<String> componentTooltip;

    public ManualPageMultiblock(ManualInstance manual, String text, MultiblockHandler.IMultiblock multiblock) {
        super(manual, text);
        this.multiblock = multiblock;
    }

    @Override
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        IngredientStack[] totalMaterials;
        int yOff = 0;
        if (this.multiblock.getStructureManual() != null) {
            ItemStack[][][] structure = this.multiblock.getStructureManual();
            this.structureHeight = structure.length;
            this.structureWidth = 0;
            this.structureLength = 0;
            this.rotX = 25.0f;
            this.rotY = 135.0f;
            this.countPerLevel = new int[this.structureHeight];
            this.blockCount = 0;
            for (int h = 0; h < structure.length; ++h) {
                if (structure[h].length - 1 > this.structureLength) {
                    this.structureLength = structure[h].length - 1;
                }
                int perLvl = 0;
                for (int l = 0; l < structure[h].length; ++l) {
                    if (structure[h][l].length - 1 > this.structureWidth) {
                        this.structureWidth = structure[h][l].length - 1;
                    }
                    for (ItemStack ss : structure[h][l]) {
                        if (ss == null) continue;
                        ++perLvl;
                    }
                }
                this.countPerLevel[h] = perLvl;
                this.blockCount += perLvl;
            }
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
            boolean canRenderFormed = this.multiblock.canRenderFormedStructure();
            float f = (float)Math.sqrt(this.structureHeight * this.structureHeight + this.structureWidth * this.structureWidth + this.structureLength * this.structureLength);
            float scale = this.multiblock.getManualScale();
            yOff = (int)((double)this.multiblock.getManualScale() * Math.sqrt(this.structureHeight * this.structureHeight + this.structureWidth * this.structureWidth + this.structureLength * this.structureLength));
            yOff = Math.max(10 + (canRenderFormed ? 12 : 0) + (this.structureHeight > 1 ? 36 : 0), yOff);
            yOff = 10 + Math.max(10 + (this.multiblock.canRenderFormedStructure() ? 12 : 0) + (this.structureHeight > 1 ? 36 : 0), (int)(f * scale));
            pageButtons.add(new GuiButtonManualNavigation(gui, 100, x + 4, y + yOff / 2 - (canRenderFormed ? 11 : 5), 10, 10, 4));
            if (canRenderFormed) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 103, x + 4, y + yOff / 2 + 1, 10, 10, 6));
            }
            if (this.structureHeight > 1) {
                pageButtons.add(new GuiButtonManualNavigation(gui, 101, x + 4, y + yOff / 2 - (canRenderFormed ? 14 : 8) - 16, 10, 16, 3));
                pageButtons.add(new GuiButtonManualNavigation(gui, 102, x + 4, y + yOff / 2 + (canRenderFormed ? 14 : 8), 10, 16, 2));
            }
        }
        if ((totalMaterials = this.multiblock.getTotalMaterials()) != null) {
            int ss;
            this.componentTooltip = new ArrayList<String>();
            this.componentTooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.reqMaterial", (Object[])new Object[0]));
            int maxOff = 1;
            boolean hasAnyItems = false;
            boolean[] hasItems = new boolean[totalMaterials.length];
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                ItemStack inSlot;
                if (totalMaterials[ss] == null) continue;
                IngredientStack req = totalMaterials[ss];
                int reqSize = req.inputSize;
                for (int slot = 0; !(slot >= ManualUtils.mc().field_71439_g.field_71071_by.func_70302_i_() || (inSlot = ManualUtils.mc().field_71439_g.field_71071_by.func_70301_a(slot)) != null && req.matchesItemStackIgnoringSize(inSlot) && (reqSize -= inSlot.field_77994_a) <= 0); ++slot) {
                }
                if (reqSize <= 0) {
                    hasItems[ss] = true;
                    if (!hasAnyItems) {
                        hasAnyItems = true;
                    }
                }
                maxOff = Math.max(maxOff, ("" + req.inputSize).length());
            }
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                if (totalMaterials[ss] == null) continue;
                IngredientStack req = totalMaterials[ss];
                int indent = maxOff - ("" + req.inputSize).length();
                String sIndent = "";
                if (indent > 0) {
                    for (int ii = 0; ii < indent; ++ii) {
                        sIndent = sIndent + "0";
                    }
                }
                String s = hasItems[ss] ? TextFormatting.GREEN + TextFormatting.BOLD.toString() + "\u2713" + TextFormatting.RESET + " " : (hasAnyItems ? "   " : "");
                s = s + TextFormatting.GRAY + sIndent + req.inputSize + "x " + TextFormatting.RESET;
                ItemStack example = req.getExampleStack();
                s = example != null ? s + example.func_77953_t().field_77937_e + example.func_82833_r() : s + "???";
                this.componentTooltip.add(s);
            }
        }
        super.initPage(gui, x, y + yOff, pageButtons);
    }

    @Override
    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        if (this.multiblock.getStructureManual() != null) {
            if (this.canTick) {
                ++this.tick;
            }
            ItemStack[][][] structure = this.multiblock.getStructureManual();
            int prevLayers = 0;
            if (this.showLayer != -1) {
                for (int ll = 0; ll < this.showLayer; ++ll) {
                    prevLayers += this.countPerLevel[ll];
                }
            }
            int limiter = prevLayers + this.tick / 40 % ((this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) + 4);
            int xHalf = this.structureWidth * 5 - this.structureLength * 5;
            int yOffPartial = (this.structureHeight - 1) * 16 + this.structureWidth * 8 + this.structureLength * 8;
            int yOffTotal = Math.max(52, yOffPartial + 16);
            GlStateManager.func_179091_B();
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            int i = 0;
            ItemStack highlighted = null;
            BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
            float f = (float)Math.sqrt(this.structureHeight * this.structureHeight + this.structureWidth * this.structureWidth + this.structureLength * this.structureLength);
            float scale = this.multiblock.getManualScale();
            yOffTotal = 10 + Math.max(10 + (this.multiblock.canRenderFormedStructure() ? 12 : 0) + (this.structureHeight > 1 ? 36 : 0), (int)(f * scale));
            GlStateManager.func_179109_b((float)(x + 60), (float)((float)(y + 10) + f / 2.0f * scale), (float)Math.max(this.structureHeight, Math.max(this.structureWidth, this.structureLength)));
            GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)1.0f);
            GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.rotY, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.showCompleted) {
                this.multiblock.renderFormedStructure();
            } else {
                GlStateManager.func_179140_f();
                if (this.structureWidth % 2 == 1) {
                    GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)0.0f);
                }
                int iterator = 0;
                for (int h = 0; h < structure.length; ++h) {
                    if (this.showLayer != -1 && h > this.showLayer) continue;
                    ItemStack[][] level = structure[h];
                    for (int l = 0; l < level.length; ++l) {
                        ItemStack[] row = level[l];
                        for (int w = row.length - 1; w >= 0; --w) {
                            int xx = 60 + xHalf - 10 * w + 10 * l - 7;
                            int yy = yOffPartial - 5 * w - 5 * l - 12 * h;
                            if (row[w] == null || i > limiter) continue;
                            ++i;
                            Block b = Block.func_149634_a((Item)row[w].func_77973_b());
                            ManualUtils.mc().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)((float)(w - this.structureWidth / 2) - 0.5f), (float)(h - this.structureHeight / 2), (float)((float)(l - this.structureLength / 2) + 0.5f));
                            if (!this.multiblock.overwriteBlockRender(row[w], iterator++) && b != null) {
                                blockRender.func_175016_a(b.func_176203_a(row[w].func_77960_j()), 1.0f);
                            }
                            GlStateManager.func_179121_F();
                            if (mx < x + xx || mx >= x + xx + 16 || my < y + yy || my >= y + yy + 16) continue;
                            highlighted = row[w];
                        }
                    }
                }
            }
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
            this.manual.fontRenderer.func_78264_a(true);
            if (this.localizedText != null && !this.localizedText.isEmpty()) {
                this.manual.fontRenderer.func_78279_b(this.localizedText, x, y + yOffTotal, 120, this.manual.getTextColour());
            }
            this.manual.fontRenderer.func_78264_a(false);
            if (this.componentTooltip != null) {
                this.manual.fontRenderer.func_175065_a("?", (float)(x + 116), (float)(y + yOffTotal / 2 - 4), this.manual.getTextColour(), false);
                if (mx >= x + 116 && mx < x + 122 && my >= y + yOffTotal / 2 - 4 && my < y + yOffTotal / 2 + 4) {
                    gui.drawHoveringText(this.componentTooltip, mx, my, this.manual.fontRenderer);
                }
            }
        }
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
        if (clickX >= 40 && clickX < 144 && mx >= 20 && mx < 164 && clickY >= 30 && clickY < 130 && my >= 30 && my < 180) {
            int dx = mx - lastX;
            int dy = my - lastY;
            this.rotY += (float)dx / 104.0f * 80.0f;
            this.rotX += (float)dy / 100.0f * 80.0f;
        }
    }

    @Override
    public void buttonPressed(GuiManual gui, GuiButton button) {
        if (button.field_146127_k == 100) {
            this.canTick = !this.canTick;
            ((GuiButtonManualNavigation)button).type = ((GuiButtonManualNavigation)button).type == 4 ? 5 : 4;
        } else if (button.field_146127_k == 101) {
            this.showLayer = Math.min(this.showLayer + 1, this.structureHeight - 1);
            this.tick = this.countPerLevel[this.showLayer] * 40;
        } else if (button.field_146127_k == 102) {
            this.showLayer = Math.max(this.showLayer - 1, -1);
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
        } else if (button.field_146127_k == 103) {
            this.showCompleted = !this.showCompleted;
        }
        super.buttonPressed(gui, button);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        return false;
    }
}

