/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;

public class ShaderCaseDrill
extends ShaderCase {
    public String additionalTexture = null;
    public TextureAtlasSprite i_drillBase;
    public TextureAtlasSprite i_drillOverlay;
    public TextureAtlasSprite i_drillUncoloured;
    public TextureAtlasSprite i_drillAdditional;

    public ShaderCaseDrill(String overlayType, int[] colourGrip, int[] colourPrimary, int[] colourSecondary, String additionalTexture) {
        super(overlayType, colourGrip, colourPrimary, colourSecondary, "immersiveengineering:items/shaders/drill_diesel_");
        this.additionalTexture = additionalTexture;
    }

    @Override
    public String getShaderType() {
        return "drill";
    }

    @Override
    public int getPasses(ItemStack shader, ItemStack item, String modelPart) {
        if (modelPart.equals("drill_head") || modelPart.equals("upgrade_damage0") || modelPart.equals("upgrade_damage1") || modelPart.equals("upgrade_damage2") || modelPart.equals("upgrade_damage3") || modelPart.equals("upgrade_damage4")) {
            return 1;
        }
        if (modelPart.equals("upgrade_speed") || modelPart.equals("upgrade_waterproof")) {
            return 2;
        }
        int i = this.additionalTexture != null ? 1 : 0;
        return 3 + i;
    }

    @Override
    public TextureAtlasSprite getReplacementSprite(ItemStack shader, ItemStack item, String modelPart, int pass) {
        if (modelPart.equals("drill_head") || modelPart.equals("upgrade_damage0") || modelPart.equals("upgrade_damage1") || modelPart.equals("upgrade_damage2") || modelPart.equals("upgrade_damage3") || modelPart.equals("upgrade_damage4")) {
            return null;
        }
        int maxPass = this.getPasses(shader, item, modelPart);
        if (pass == maxPass - 1) {
            return this.i_drillUncoloured;
        }
        if (pass == maxPass - 2 && this.i_drillAdditional != null) {
            return this.i_drillAdditional;
        }
        return pass == 0 ? this.i_drillBase : this.i_drillOverlay;
    }

    @Override
    public int[] getRGBAColourModifier(ItemStack shader, ItemStack item, String modelPart, int pass) {
        int maxPass = this.getPasses(shader, item, modelPart);
        if (pass == maxPass - 1) {
            return defaultWhite;
        }
        if (pass == maxPass - 2 && this.i_drillAdditional != null) {
            return this.colourOverlay;
        }
        int i = this.getTextureType(modelPart, pass);
        if (i == 0) {
            return this.colourUnderlying;
        }
        if (i == 1) {
            return this.colourPrimary;
        }
        if (i == 2) {
            return this.colourSecondary;
        }
        return defaultWhite;
    }

    public int getTextureType(String modelPart, int pass) {
        if (modelPart.equals("drill_grip")) {
            return pass == 0 ? 0 : pass + 1;
        }
        return pass + 1;
    }

    @Override
    public void stichTextures(TextureMap map, int sheetID) {
        this.i_drillBase = ApiUtils.getRegisterSprite(map, "immersiveengineering:items/shaders/drill_diesel_0");
        this.i_drillOverlay = ApiUtils.getRegisterSprite(map, this.baseTexturePath + "1_" + this.overlayType);
        this.i_drillUncoloured = ApiUtils.getRegisterSprite(map, "immersiveengineering:items/shaders/drill_diesel_uncoloured");
        if (this.additionalTexture != null) {
            this.i_drillAdditional = ApiUtils.getRegisterSprite(map, this.baseTexturePath + this.additionalTexture);
        }
    }

    @Override
    public void modifyRender(ItemStack shader, ItemStack item, String modelPart, int pass, boolean pre, boolean inventory) {
    }
}

