/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class AssemblerHandler {
    private static final HashMap<Class<? extends IRecipe>, IRecipeAdapter> registry = new LinkedHashMap<Class<? extends IRecipe>, IRecipeAdapter>();

    public static void registerRecipeAdapter(Class<? extends IRecipe> recipeClass, IRecipeAdapter adapter) {
        registry.put(recipeClass, adapter);
    }

    public static IRecipeAdapter findAdapterForClass(Class<? extends IRecipe> recipeClass) {
        IRecipeAdapter adapter = registry.get(recipeClass);
        if (adapter == null && recipeClass != IRecipe.class) {
            adapter = AssemblerHandler.findAdapterForClass(recipeClass.getSuperclass());
            registry.put(recipeClass, adapter);
        }
        return adapter;
    }

    public static IRecipeAdapter findAdapter(IRecipe recipe) {
        return AssemblerHandler.findAdapterForClass(recipe.getClass());
    }

    public static RecipeQuery createQuery(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                return new RecipeQuery(FluidUtil.getFluidContained((ItemStack)stack), stack.field_77994_a);
            }
            return new RecipeQuery(stack, stack.field_77994_a);
        }
        if (o instanceof IngredientStack) {
            return new RecipeQuery(o, ((IngredientStack)o).inputSize);
        }
        return new RecipeQuery(o, 1);
    }

    public static class RecipeQuery {
        public Object query;
        public int querySize;

        public RecipeQuery(Object query, int querySize) {
            this.query = query;
            this.querySize = querySize;
        }
    }

    public static interface IRecipeAdapter<R extends IRecipe> {
        public RecipeQuery[] getQueriedInputs(R var1);
    }
}

