/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BulletHandler {
    public static ItemStack emptyCasing;
    public static ItemStack emptyShell;
    public static ItemStack basicCartridge;
    public static List<String> homingCartridges;
    public static HashMap<String, IBullet> registry;

    public static void registerBullet(String name, IBullet bullet) {
        registry.put(name, bullet);
    }

    public static IBullet getBullet(String name) {
        return registry.get(name);
    }

    public static ItemStack getBulletStack(String key) {
        ItemStack stack = basicCartridge.func_77946_l();
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("bullet", key);
        return stack;
    }

    static {
        homingCartridges = new ArrayList<String>();
        registry = new LinkedHashMap<String, IBullet>();
    }

    public static class DamagingBullet
    implements IBullet {
        final Function<Entity[], DamageSource> damageSourceGetter;
        final float damage;
        boolean resetHurt = false;
        boolean setFire = false;
        ItemStack casing;
        ResourceLocation[] textures;

        public DamagingBullet(Function<Entity[], DamageSource> damageSourceGetter, float damage, ItemStack casing, ResourceLocation ... textures) {
            this(damageSourceGetter, damage, false, false, casing, textures);
        }

        public DamagingBullet(Function<Entity[], DamageSource> damageSourceGetter, float damage, boolean resetHurt, boolean setFire, ItemStack casing, ResourceLocation ... textures) {
            this.damageSourceGetter = damageSourceGetter;
            this.damage = damage;
            this.resetHurt = resetHurt;
            this.setFire = setFire;
            this.casing = casing;
            this.textures = textures;
        }

        float getDamage(boolean headshot) {
            return this.damage * (headshot ? 1.5f : 1.0f);
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
            if (!world.field_72995_K && target.field_72308_g != null && this.damageSourceGetter != null && target.field_72308_g.func_70097_a(this.damageSourceGetter.apply(new Entity[]{projectile, shooter, target.field_72308_g}), this.getDamage(headshot))) {
                if (this.resetHurt) {
                    target.field_72308_g.field_70172_ad = 0;
                }
                if (this.setFire) {
                    target.field_72308_g.func_70015_d(3);
                }
            }
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return this.casing;
        }

        @Override
        public ResourceLocation[] getTextures() {
            return this.textures;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static interface IBullet {
        default public boolean isProperCartridge() {
            return true;
        }

        default public String getUnlocalizedName(ItemStack cartridge, String baseName) {
            return baseName;
        }

        default public void addTooltip(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        }

        default public int getProjectileCount(EntityPlayer shooter, ItemStack cartridge) {
            return 1;
        }

        default public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity protetile, boolean charged) {
            return protetile;
        }

        public void onHitTarget(World var1, RayTraceResult var2, EntityLivingBase var3, Entity var4, boolean var5);

        public ItemStack getCasing(ItemStack var1);

        public ResourceLocation[] getTextures();

        public int getColour(ItemStack var1, int var2);
    }
}

