/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IEItemFontRender
extends FontRenderer {
    static HashMap<Character, CharReplacement> unicodeReplacements = new HashMap();
    int[] backupColours;
    String colourFormattingKeys = "0123456789abcdef";
    public float customSpaceWidth = 4.0f;
    public float spacingModifier = 0.0f;
    public boolean verticalBoldness = false;

    public IEItemFontRender() {
        super(ClientUtils.mc().field_71474_y, new ResourceLocation("textures/font/ascii.png"), ClientUtils.mc().field_71446_o, false);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            this.func_78264_a(ClientUtils.mc().func_135016_M().func_135042_a());
            this.func_78275_b(ClientUtils.mc().func_135016_M().func_135044_b());
        }
        ((IReloadableResourceManager)ClientUtils.mc().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        this.backupColours = Arrays.copyOf(this.field_78285_g, 32);
    }

    public void func_78255_a(String text, boolean shadow) {
        int idx = -1;
        int loop = 0;
        HashMap<Integer, Integer> formattingReplacements = new HashMap<Integer, Integer>();
        while ((idx = text.indexOf("<hexcol=")) >= 0 && loop++ < 20) {
            int end = text.indexOf(">", idx);
            if (end < 0) continue;
            String rep = "ERROR";
            String s = text.substring(idx, end + 1);
            int formatEnd = s.indexOf(":");
            if (formatEnd >= 0) {
                rep = s.substring(formatEnd + 1, s.length() - 1);
                String hex = s.substring("<hexcol=".length(), formatEnd);
                try {
                    int formatting;
                    int hexColour = Integer.parseInt(hex, 16);
                    if (formattingReplacements.containsKey(hexColour)) {
                        formatting = (Integer)formattingReplacements.get(hexColour);
                    } else {
                        for (formatting = 0; formatting < 16 && text.contains("\u00a7" + this.colourFormattingKeys.charAt(formatting)); ++formatting) {
                        }
                    }
                    if (formatting < 16) {
                        rep = "\u00a7" + this.colourFormattingKeys.charAt(formatting) + rep + "\u00a7r";
                        this.field_78285_g[formatting] = hexColour;
                        this.field_78285_g[16 + formatting] = ClientUtils.getDarkenedTextColour(hexColour);
                    }
                    formattingReplacements.put(hexColour, formatting);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            text = text.replace(s, rep);
        }
        if (this.verticalBoldness) {
            float startX = this.field_78295_j;
            float startY = this.field_78296_k;
            float yOffset = this.func_82883_a() ? 0.5f : 1.0f;
            super.func_78255_a(text, shadow);
            this.field_78296_k = startY + yOffset;
            this.field_78295_j = startX;
            super.func_78255_a(text, shadow);
            this.field_78296_k -= yOffset;
        } else {
            super.func_78255_a(text, shadow);
        }
        this.field_78285_g = Arrays.copyOf(this.backupColours, 32);
    }

    protected float func_78277_a(char ch, boolean italic) {
        CharReplacement cr = unicodeReplacements.get(Character.valueOf(ch));
        if (cr != null) {
            return cr.replaceChar(this.field_78295_j, this.field_78296_k);
        }
        return super.func_78277_a(ch, italic);
    }

    protected float func_78266_a(int ch, boolean italic) {
        if (ch == 32) {
            return this.customSpaceWidth;
        }
        return super.func_78266_a(ch, italic) + this.spacingModifier;
    }

    public float getCharWidthFloat(char character) {
        if (character == ' ') {
            return this.customSpaceWidth;
        }
        return (float)super.func_78263_a(character) + this.spacingModifier;
    }

    public int func_78263_a(char character) {
        return (int)this.getCharWidthFloat(character);
    }

    public int func_78256_a(String text) {
        if (text == null) {
            return 0;
        }
        float i = 0.0f;
        boolean flag = false;
        for (int j = 0; j < text.length(); ++j) {
            char c0 = text.charAt(j);
            float k = this.getCharWidthFloat(c0);
            if (k < 0.0f && j < text.length() - 1) {
                if ((c0 = text.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0.0f;
            }
            i += k;
            if (!flag || !(k > 0.0f)) continue;
            i += 1.0f;
        }
        return (int)i;
    }

    public int func_78259_e(String str, int wrapWidth) {
        int k;
        int i = str.length();
        float j = 0.0f;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c0 = str.charAt(k);
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += this.getCharWidthFloat(c0);
                    if (!flag) break;
                    j += 1.0f;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (k >= i - 1) break;
                    if ((c1 = str.charAt(++k)) != 'l' && c1 != 'L') {
                        if (!(c1 == 'r' || c1 == 'R' || c1 >= '0' && c1 <= '9' || c1 >= 'a' && c1 <= 'f') && (c1 < 'A' || c1 > 'F')) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                break;
            }
            if (j > (float)wrapWidth) break;
        }
        return k != i && l != -1 && l < k ? l : k;
    }

    static {
        unicodeReplacements.put(Character.valueOf((char)Integer.parseInt("260E", 16)), new CharReplacement("immersiveengineering:textures/gui/hudElements.png", 0.5f, 0.75f, 0.5625f, 0.8125f));
    }

    static class CharReplacement {
        private final String textureSheet;
        private final float uMin;
        private final float vMin;
        private final float uMax;
        private final float vMax;

        public CharReplacement(String textureSheet, float uMin, float vMin, float uMax, float vMax) {
            this.textureSheet = textureSheet;
            this.uMin = uMin;
            this.vMin = vMin;
            this.uMax = uMax;
            this.vMax = vMax;
        }

        float replaceChar(float posX, float posY) {
            ClientUtils.bindTexture(this.textureSheet);
            GlStateManager.func_187447_r((int)5);
            GlStateManager.func_187426_b((float)this.uMin, (float)this.vMin);
            GlStateManager.func_187435_e((float)posX, (float)posY, (float)0.0f);
            GlStateManager.func_187426_b((float)this.uMin, (float)this.vMax);
            GlStateManager.func_187435_e((float)posX, (float)(posY + 7.99f), (float)0.0f);
            GlStateManager.func_187426_b((float)this.uMax, (float)this.vMin);
            GlStateManager.func_187435_e((float)(posX + 7.99f), (float)posY, (float)0.0f);
            GlStateManager.func_187426_b((float)this.uMax, (float)this.vMax);
            GlStateManager.func_187435_e((float)(posX + 7.99f), (float)(posY + 7.99f), (float)0.0f);
            GlStateManager.func_187437_J();
            return 8.02f;
        }
    }
}

