/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.models.smart.ConnModelReal;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.apache.commons.lang3.tuple.Pair;

public class IESmartObjModel
extends OBJModel.OBJBakedModel {
    public static Map<ComparableItemStack, IBakedModel> cachedBakedItemModels = new ConcurrentHashMap<ComparableItemStack, IBakedModel>();
    public static HashMap<ConnModelReal.ExtBlockstateAdapter, List<BakedQuad>> modelCache = new HashMap();
    IBakedModel baseModel;
    HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap;
    ImmutableList<BakedQuad> bakedQuads;
    TextureAtlasSprite tempSprite;
    ItemStack tempStack;
    IBlockState tempState;
    VertexFormat format;
    ItemOverrideList overrideList;
    static Field f_textures;

    public IESmartObjModel(IBakedModel baseModel, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, HashMap<ItemCameraTransforms.TransformType, Matrix4> transformationMap) {
        OBJModel oBJModel = model;
        oBJModel.getClass();
        super(oBJModel, model, state, format, textures);
        this.transformationMap = new HashMap();
        this.overrideList = new ItemOverrideList(new ArrayList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                ComparableItemStack comp = ApiUtils.createComparableItemStack(stack);
                if (comp == null) {
                    return originalModel;
                }
                if (cachedBakedItemModels.containsKey(comp)) {
                    return cachedBakedItemModels.get(comp);
                }
                if (!(originalModel instanceof IESmartObjModel)) {
                    return originalModel;
                }
                IESmartObjModel model = (IESmartObjModel)originalModel;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
                TextureAtlasSprite missing = Minecraft.func_71410_x().func_147117_R().func_110572_b(new ResourceLocation("missingno").toString());
                for (String s : model.getModel().getMatLib().getMaterialNames()) {
                    ShaderCase sCase;
                    ItemStack shader;
                    TextureAtlasSprite sprite = null;
                    if (stack.func_77973_b() instanceof IShaderEquipableItem && (shader = ((IShaderEquipableItem)stack.func_77973_b()).getShaderItem(stack)) != null && shader.func_77973_b() instanceof IShaderItem && (sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, stack, ((IShaderEquipableItem)stack.func_77973_b()).getShaderType())) != null) {
                        sprite = sCase.getReplacementSprite(shader, stack, s, 0);
                    }
                    if (sprite == null && stack.func_77973_b() instanceof IOBJModelCallback) {
                        sprite = ((IOBJModelCallback)stack.func_77973_b()).getTextureReplacement(stack, s);
                    }
                    if (sprite == null) {
                        sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(model.getModel().getMatLib().getMaterial(s).getTexture().getTextureLocation().toString());
                    }
                    if (sprite == null) {
                        sprite = missing;
                    }
                    builder.put((Object)s, (Object)sprite);
                }
                builder.put((Object)"missingno", (Object)missing);
                IESmartObjModel bakedModel = new IESmartObjModel(model.baseModel, model.getModel(), model.getState(), model.getFormat(), (ImmutableMap<String, TextureAtlasSprite>)builder.build(), IESmartObjModel.this.transformationMap);
                bakedModel.tempStack = stack;
                cachedBakedItemModels.put(comp, (IBakedModel)bakedModel);
                return bakedModel;
            }
        };
        this.baseModel = baseModel;
        this.transformationMap = transformationMap;
        this.format = format;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Matrix4 matrix;
        if (this.transformationMap == null || this.transformationMap.isEmpty()) {
            return super.handlePerspective(cameraTransformType);
        }
        Matrix4 matrix4 = matrix = this.transformationMap.containsKey(cameraTransformType) ? this.transformationMap.get(cameraTransformType).copy() : new Matrix4();
        if (this.tempStack != null && this.tempStack.func_77973_b() instanceof IOBJModelCallback) {
            matrix = ((IOBJModelCallback)this.tempStack.func_77973_b()).handlePerspective(this.tempStack, cameraTransformType, matrix);
        }
        return Pair.of((Object)((Object)this), (Object)matrix.toMatrix4f());
    }

    VertexFormat getFormat() {
        return this.format;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        this.tempState = blockState;
        if (blockState instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)blockState;
            ConnModelReal.ExtBlockstateAdapter adapter = new ConnModelReal.ExtBlockstateAdapter(exState);
            if (!modelCache.containsKey(adapter)) {
                IModelState s;
                IESmartObjModel model = null;
                if (exState.getUnlistedNames().contains(Properties.AnimationProperty) && (s = (IModelState)exState.getValue(Properties.AnimationProperty)) instanceof OBJModel.OBJState) {
                    OBJModel.OBJState objstate = (OBJModel.OBJState)s;
                    if (objstate.parent == null || objstate.parent == TRSRTransformation.identity()) {
                        objstate.parent = this.getState();
                    }
                    if (objstate.getVisibilityMap().containsKey("OBJModel.Group.All.Key") || objstate.getVisibilityMap().containsKey("OBJModel.Group.All.Except.Key")) {
                        this.updateStateVisibilityMap(objstate);
                    }
                    model = new IESmartObjModel(this.baseModel, this.getModel(), (IModelState)objstate, this.getFormat(), this.getTextures(), this.transformationMap);
                }
                if (model == null) {
                    model = new IESmartObjModel(this.baseModel, this.getModel(), this.getState(), this.getFormat(), this.getTextures(), this.transformationMap);
                }
                model.tempState = blockState;
                modelCache.put(adapter, (List<BakedQuad>)super.buildQuads());
            }
            return Collections.synchronizedList(Lists.newArrayList((Iterable)modelCache.get(adapter)));
        }
        if (this.bakedQuads == null) {
            this.bakedQuads = this.buildQuads();
        }
        List<BakedQuad> quadList = Collections.synchronizedList(Lists.newArrayList(this.bakedQuads));
        return quadList;
    }

    private ImmutableList<BakedQuad> buildQuads() {
        List<Object> quads = Lists.newArrayList();
        ItemStack shader = null;
        ShaderCase sCase = null;
        IOBJModelCallback callback = null;
        ItemStack callbackObject = null;
        if (this.tempStack != null && this.tempStack.func_77973_b() instanceof IShaderEquipableItem && (shader = ((IShaderEquipableItem)this.tempStack.func_77973_b()).getShaderItem(this.tempStack)) != null && shader.func_77973_b() instanceof IShaderItem) {
            sCase = ((IShaderItem)shader.func_77973_b()).getShaderCase(shader, this.tempStack, ((IShaderEquipableItem)this.tempStack.func_77973_b()).getShaderType());
        }
        if (this.tempStack != null && this.tempStack.func_77973_b() instanceof IOBJModelCallback) {
            callback = (IOBJModelCallback)this.tempStack.func_77973_b();
            callbackObject = this.tempStack;
        } else if (this.tempState != null && this.tempState instanceof IExtendedBlockState && ((IExtendedBlockState)this.tempState).getUnlistedNames().contains(IOBJModelCallback.PROPERTY)) {
            callback = (IOBJModelCallback)((IExtendedBlockState)this.tempState).getValue(IOBJModelCallback.PROPERTY);
            callbackObject = this.tempState;
        }
        for (OBJModel.Group g : this.getModel().getMatLib().getGroups().values()) {
            if (callback != null && !callback.shouldRenderGroup(callbackObject, g.getName())) continue;
            int maxPasses = 1;
            if (sCase != null) {
                maxPasses = sCase.getPasses(shader, this.tempStack, g.getName());
            }
            Set<OBJModel.Face> faces = Collections.synchronizedSet(new LinkedHashSet());
            Optional<TRSRTransformation> transform = Optional.absent();
            if (this.getState() instanceof OBJModel.OBJState) {
                OBJModel.OBJState state = (OBJModel.OBJState)this.getState();
                if (state.parent != null) {
                    transform = state.parent.apply(Optional.absent());
                }
                if (callback != null) {
                    transform = callback.applyTransformations(callbackObject, g.getName(), transform);
                }
                if (state.getGroupsWithVisibility(true).contains(g.getName())) {
                    faces.addAll(g.applyTransform(transform));
                }
            } else {
                transform = this.getState().apply(Optional.absent());
                if (callback != null) {
                    transform = callback.applyTransformations(callbackObject, g.getName(), transform);
                }
                faces.addAll(g.applyTransform((Optional)transform));
            }
            for (int pass = 0; pass < maxPasses; ++pass) {
                float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
                if (sCase != null) {
                    int[] iCol = sCase.getRGBAColourModifier(shader, this.tempStack, g.getName(), pass);
                    for (int i = 0; i < iCol.length; ++i) {
                        colour[i] = (float)iCol[i] / 255.0f;
                    }
                } else if (callback != null) {
                    int iCol = callback.getRenderColour(callbackObject, g.getName());
                    colour[0] = (float)(iCol >> 16 & 0xFF) / 255.0f;
                    colour[1] = (float)(iCol >> 8 & 0xFF) / 255.0f;
                    colour[2] = (float)(iCol & 0xFF) / 255.0f;
                    colour[3] = (float)(iCol >> 24 & 0xFF) / 255.0f;
                }
                for (OBJModel.Face f : faces) {
                    this.tempSprite = null;
                    if (this.getModel().getMatLib().getMaterial(f.getMaterialName()).isWhite() && !"null".equals(f.getMaterialName())) {
                        for (OBJModel.Vertex v : f.getVertices()) {
                            if (v.getMaterial().equals(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()))) continue;
                            v.setMaterial(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()));
                        }
                        this.tempSprite = ModelLoader.White.INSTANCE;
                    } else {
                        if (sCase != null) {
                            this.tempSprite = sCase.getReplacementSprite(shader, this.tempStack, g.getName(), pass);
                        }
                        if (this.tempSprite == null && callback != null) {
                            this.tempSprite = callback.getTextureReplacement(callbackObject, f.getMaterialName());
                        }
                        if (this.tempSprite == null && this.tempState != null && this.tempState instanceof IExtendedBlockState && ((IExtendedBlockState)this.tempState).getUnlistedNames().contains(IEProperties.OBJ_TEXTURE_REMAP)) {
                            String s;
                            HashMap map = (HashMap)((IExtendedBlockState)this.tempState).getValue(IEProperties.OBJ_TEXTURE_REMAP);
                            String string = s = map != null ? (String)map.get(g.getName()) : null;
                            if (s != null) {
                                this.tempSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(s);
                            }
                        }
                        if (this.tempSprite == null && !"null".equals(f.getMaterialName())) {
                            this.tempSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(this.getModel().getMatLib().getMaterial(f.getMaterialName()).getTexture().getTextureLocation().toString());
                        }
                    }
                    if (this.tempSprite == null) continue;
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.getFormat());
                    builder.setQuadOrientation(EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z));
                    builder.setTexture(this.tempSprite);
                    builder.setQuadTint(pass);
                    OBJModel.Normal faceNormal = f.getNormal();
                    this.putVertexData(builder, f.getVertices()[0], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[0], this.tempSprite, colour);
                    this.putVertexData(builder, f.getVertices()[1], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[1], this.tempSprite, colour);
                    this.putVertexData(builder, f.getVertices()[2], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[2], this.tempSprite, colour);
                    this.putVertexData(builder, f.getVertices()[3], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[3], this.tempSprite, colour);
                    quads.add(builder.build());
                }
            }
        }
        if (callback != null) {
            quads = callback.modifyQuads(callbackObject, (List<BakedQuad>)quads);
        }
        return ImmutableList.copyOf((Collection)quads);
    }

    protected final void putVertexData(UnpackedBakedQuad.Builder builder, OBJModel.Vertex v, OBJModel.Normal faceNormal, OBJModel.TextureCoordinate defUV, TextureAtlasSprite sprite, float[] colour) {
        block6: for (int e = 0; e < this.getFormat().func_177345_h(); ++e) {
            switch (this.getFormat().func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{v.getPos().x, v.getPos().y, v.getPos().z, v.getPos().w});
                    continue block6;
                }
                case COLOR: {
                    float d = v.hasNormal() ? LightUtil.diffuseLight((float)v.getNormal().x, (float)v.getNormal().y, (float)v.getNormal().z) : LightUtil.diffuseLight((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
                    if (v.getMaterial() != null) {
                        builder.put(e, new float[]{d * v.getMaterial().getColor().x * colour[0], d * v.getMaterial().getColor().y * colour[1], d * v.getMaterial().getColor().z * colour[2], v.getMaterial().getColor().w * colour[3]});
                        continue block6;
                    }
                    builder.put(e, new float[]{d * colour[0], d * colour[1], d * colour[2], 1.0f * colour[3]});
                    continue block6;
                }
                case UV: {
                    if (sprite == null) {
                        sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                    }
                    if (!v.hasTextureCoordinate()) {
                        builder.put(e, new float[]{sprite.func_94214_a((double)(defUV.u * 16.0f)), sprite.func_94207_b((double)((1.0f - defUV.v) * 16.0f)), 0.0f, 1.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{sprite.func_94214_a((double)(v.getTextureCoordinate().u * 16.0f)), sprite.func_94207_b((double)((1.0f - v.getTextureCoordinate().v) * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (!v.hasNormal()) {
                        builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    static int getExtendedStateHash(IExtendedBlockState state) {
        return state.hashCode() * 31 + state.getUnlistedProperties().hashCode();
    }

    protected void updateStateVisibilityMap(OBJModel.OBJState state) {
        if (state.getVisibilityMap().containsKey("OBJModel.Group.All.Key")) {
            boolean operation = (Boolean)state.getVisibilityMap().get("OBJModel.Group.All.Key");
            state.getVisibilityMap().clear();
            for (String s : this.getModel().getMatLib().getGroups().keySet()) {
                state.getVisibilityMap().put(s, OBJModel.OBJState.Operation.SET_TRUE.performOperation(operation));
            }
        } else if (state.getVisibilityMap().containsKey("OBJModel.Group.All.Except.Key")) {
            List exceptList = state.getGroupNamesFromMap().subList(1, state.getGroupNamesFromMap().size());
            state.getVisibilityMap().remove("OBJModel.Group.All.Except.Key");
            for (String s : this.getModel().getMatLib().getGroups().keySet()) {
                if (exceptList.contains(s)) continue;
                state.getVisibilityMap().put(s, OBJModel.OBJState.Operation.SET_TRUE.performOperation(((Boolean)state.getVisibilityMap().get(s)).booleanValue()));
            }
        } else {
            for (String s : state.getVisibilityMap().keySet()) {
                state.getVisibilityMap().put(s, OBJModel.OBJState.Operation.SET_TRUE.performOperation(((Boolean)state.getVisibilityMap().get(s)).booleanValue()));
            }
        }
    }

    public static ImmutableMap<String, TextureAtlasSprite> getTexturesForOBJModel(IBakedModel model) {
        try {
            if (f_textures == null) {
                f_textures = OBJModel.OBJBakedModel.class.getDeclaredField("textures");
                f_textures.setAccessible(true);
            }
            return (ImmutableMap)f_textures.get(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ImmutableMap<String, TextureAtlasSprite> getTextures() {
        try {
            if (f_textures == null) {
                f_textures = OBJModel.OBJBakedModel.class.getDeclaredField("textures");
                f_textures.setAccessible(true);
            }
            return (ImmutableMap)f_textures.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

