/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.client.models.obj.IEOBJModel;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;

public class IEOBJLoader
implements ICustomModelLoader {
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, IEOBJModel> cache = new HashMap<ResourceLocation, IEOBJModel>();
    private final Map<ResourceLocation, Exception> errors = new HashMap<ResourceLocation, Exception>();
    public static IEOBJLoader instance = new IEOBJLoader();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        IELogger.info("Custom OBJLoader: Domain has been added: " + domain.toLowerCase());
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj.ie");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        Object model;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file) && (model = OBJLoader.INSTANCE.loadModel(modelLocation)) instanceof OBJModel) {
            IEOBJModel ieobj = new IEOBJModel(((OBJModel)model).getMatLib(), file);
            this.cache.put(modelLocation, ieobj);
        }
        if ((model = this.cache.get(file)) == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        return model;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
        this.errors.clear();
    }
}

