/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.energy.wires.IICProxy;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.EventHandler;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class IESaveData
extends WorldSavedData {
    private static IESaveData INSTANCE;
    public static final String dataName = "ImmersiveEngineering-SaveData";

    public IESaveData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int[] savedDimensions;
        for (int dim : savedDimensions = nbt.func_74759_k("savedDimensions")) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList" + dim, 10);
            ImmersiveNetHandler.INSTANCE.clearAllConnections(dim);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con == null) continue;
                ImmersiveNetHandler.INSTANCE.addConnection(dim, con.start, con);
            }
        }
        NBTTagList proxies = nbt.func_150295_c("iicProxies", 10);
        for (int i = 0; i < proxies.func_74745_c(); ++i) {
            ImmersiveNetHandler.INSTANCE.addProxy(IICProxy.readFromNBT(proxies.func_150305_b(i)));
        }
        EventHandler.validateConnsNextTick = true;
        NBTTagList mineralList = nbt.func_150295_c("mineralDepletion", 10);
        ExcavatorHandler.mineralCache.clear();
        for (int i = 0; i < mineralList.func_74745_c(); ++i) {
            NBTTagCompound tag = mineralList.func_150305_b(i);
            DimensionChunkCoords coords = DimensionChunkCoords.readFromNBT(tag);
            if (coords == null) continue;
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.MineralWorldInfo.readFromNBT(tag.func_74775_l("info"));
            ExcavatorHandler.mineralCache.put(coords, info);
        }
        NBTTagList receivedShaderList = nbt.func_150295_c("receivedShaderList", 10);
        for (int i = 0; i < receivedShaderList.func_74745_c(); ++i) {
            NBTTagCompound tag = receivedShaderList.func_150305_b(i);
            String player = tag.func_74779_i("player");
            ShaderRegistry.receivedShaders.get((Object)player).clear();
            NBTTagList playerReceived = tag.func_150295_c("received", 8);
            for (int j = 0; j < playerReceived.func_74745_c(); ++j) {
                String s = playerReceived.func_150307_f(j);
                if (s == null || s.isEmpty()) continue;
                ShaderRegistry.receivedShaders.put((Object)player, (Object)s);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        Integer[] relDim = ImmersiveNetHandler.INSTANCE.getRelevantDimensions().toArray(new Integer[0]);
        int[] savedDimensions = new int[relDim.length];
        for (int ii = 0; ii < relDim.length; ++ii) {
            savedDimensions[ii] = relDim[ii];
        }
        nbt.func_74783_a("savedDimensions", savedDimensions);
        for (int dim : savedDimensions) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
            if (world == null) continue;
            NBTTagList connectionList = new NBTTagList();
            for (ImmersiveNetHandler.Connection con : ImmersiveNetHandler.INSTANCE.getAllConnections((World)world)) {
                connectionList.func_74742_a((NBTBase)con.writeToNBT());
            }
            nbt.func_74782_a("connectionList" + dim, (NBTBase)connectionList);
        }
        NBTTagList proxies = new NBTTagList();
        for (IICProxy iic : ImmersiveNetHandler.INSTANCE.proxies.values()) {
            proxies.func_74742_a((NBTBase)iic.writeToNBT());
        }
        nbt.func_74782_a("iicProxies", (NBTBase)proxies);
        NBTTagList mineralList = new NBTTagList();
        for (Map.Entry<DimensionChunkCoords, ExcavatorHandler.MineralWorldInfo> e : ExcavatorHandler.mineralCache.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            NBTTagCompound tag = e.getKey().writeToNBT();
            tag.func_74782_a("info", (NBTBase)e.getValue().writeToNBT());
            mineralList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("mineralDepletion", (NBTBase)mineralList);
        NBTTagList receivedShaderList = new NBTTagList();
        for (String player : ShaderRegistry.receivedShaders.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("player", player);
            NBTTagList playerReceived = new NBTTagList();
            for (String shader : ShaderRegistry.receivedShaders.get((Object)player)) {
                if (shader == null || shader.isEmpty()) continue;
                playerReceived.func_74742_a((NBTBase)new NBTTagString(shader));
            }
            tag.func_74782_a("received", (NBTBase)playerReceived);
            receivedShaderList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("receivedShaderList", (NBTBase)receivedShaderList);
        return nbt;
    }

    public static void setDirty(int dimension) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && INSTANCE != null) {
            INSTANCE.func_76185_a();
        }
    }

    public static void setInstance(int dimension, IESaveData in) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            INSTANCE = in;
        }
    }
}

