/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.RayTraceResult;

public class TileEntityCapacitorLV
extends TileEntityIEBase
implements ITickable,
IFluxProvider,
IFluxReceiver,
IEnergyProvider,
IEnergyReceiver,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.ITileDrop {
    public int[] sideConfig = new int[]{-1, 0, -1, -1, -1, -1};
    FluxStorage energyStorage = new FluxStorage(this.getMaxStorage(), this.getMaxInput(), this.getMaxOutput());
    public int comparatorOutput = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            for (i = 0; i < 6; ++i) {
                this.transferEnergy(i);
            }
            if (this.field_145850_b.func_82737_E() % 32L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x1F) && (i = this.scaleStoredEnergyTo(15)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_145838_q());
            }
        }
    }

    public int scaleStoredEnergyTo(int scale) {
        return (int)((float)scale * ((float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored()));
    }

    protected void transferEnergy(int side) {
        if (this.sideConfig[side] != 1) {
            return;
        }
        EnumFacing fd = EnumFacing.func_82600_a((int)side);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(fd));
        if (tileEntity instanceof IFluxReceiver) {
            this.energyStorage.modifyEnergyStored(-((IFluxReceiver)tileEntity).receiveEnergy(fd.func_176734_d(), Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored()), false));
        } else if (tileEntity instanceof IEnergyReceiver) {
            this.energyStorage.modifyEnergyStored(-((IEnergyReceiver)tileEntity).receiveEnergy(fd.func_176734_d(), Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored()), false));
        }
    }

    @Override
    public IEEnums.SideConfig getSideConfig(int side) {
        return IEEnums.SideConfig.values()[this.sideConfig[side] + 1];
    }

    @Override
    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 0, 0);
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    public int getMaxStorage() {
        return Config.getInt("capacitorLV_storage");
    }

    public int getMaxInput() {
        return Config.getInt("capacitorLV_input");
    }

    public int getMaxOutput() {
        return Config.getInt("capacitorLV_output");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 6) {
            this.sideConfig = new int[6];
        }
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing fd) {
        return fd.ordinal() < this.sideConfig.length && this.sideConfig[fd.ordinal()] >= 0;
    }

    @Override
    public int extractEnergy(EnumFacing fd, int amount, boolean simulate) {
        if (this.field_145850_b.field_72995_K || fd.ordinal() >= this.sideConfig.length || this.sideConfig[fd.ordinal()] != 1) {
            return 0;
        }
        int r = this.energyStorage.extractEnergy(amount, simulate);
        this.markContainingBlockForUpdate(null);
        return r;
    }

    @Override
    public int getEnergyStored(EnumFacing fd) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing fd) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(EnumFacing fd, int amount, boolean simulate) {
        if (this.field_145850_b.field_72995_K || fd.ordinal() >= this.sideConfig.length || this.sideConfig[fd.ordinal()] != 0) {
            return 0;
        }
        int r = this.energyStorage.receiveEnergy(amount, simulate);
        return r;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (hammer && Config.getBoolean("colourblindSupport")) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.ordinal())];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_178784_b.func_176734_d().ordinal())];
            return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.facing", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + i), (Object[])new Object[0]), I18n.func_135052_a((String)"desc.immersiveengineering.info.blockSide.opposite", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("desc.immersiveengineering.info.blockSide.connectEnergy." + j), (Object[])new Object[0])};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        if (this.energyStorage.getEnergyStored() > 0) {
            ItemNBTHelper.setInt(stack, "energyStorage", this.energyStorage.getEnergyStored());
        }
        ItemNBTHelper.setIntArray(stack, "sideConfig", this.sideConfig);
        return stack;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "energyStorage")) {
            this.energyStorage.setEnergy(ItemNBTHelper.getInt(stack, "energyStorage"));
        }
        if (ItemNBTHelper.hasKey(stack, "sideConfig")) {
            this.sideConfig = ItemNBTHelper.getIntArray(stack, "sideConfig");
        }
    }
}

