/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityBlastFurnace
extends TileEntityMultiblockPart<TileEntityBlastFurnace>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IGuiTile {
    ItemStack[] inventory = new ItemStack[4];
    public int process = 0;
    public int processMax = 0;
    public boolean active = false;
    public int burnTime = 0;
    public int lastBurnTime = 0;

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return inf == IEBlockInterfaces.IActiveState.class ? IEProperties.BOOLEANS[0] : null;
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 1;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockStoneDecoration, 1, 1);
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0 || this.offset[2] != 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.formed && !this.isDummy()) {
            boolean a = this.active;
            if (this.burnTime > 0) {
                if (this.process > 0) {
                    int processSpeed = this.getProcessSpeed();
                    if (this.inventory[0] == null) {
                        this.process = 0;
                        this.processMax = 0;
                    } else {
                        this.process -= processSpeed;
                        if (!this.active) {
                            this.active = true;
                        }
                    }
                    this.burnTime -= processSpeed;
                    this.markContainingBlockForUpdate(null);
                }
                if (this.process <= 0) {
                    BlastFurnaceRecipe recipe;
                    if (this.active) {
                        BlastFurnaceRecipe recipe2 = this.getRecipe();
                        if (recipe2 != null) {
                            Utils.modifyInvStackSize(this.inventory, 0, -(recipe2.input instanceof ItemStack ? ((ItemStack)recipe2.input).field_77994_a : 1));
                            if (this.inventory[2] != null) {
                                this.inventory[2].field_77994_a += recipe2.output.func_77946_l().field_77994_a;
                            } else {
                                this.inventory[2] = recipe2.output.func_77946_l();
                            }
                            if (recipe2.slag != null) {
                                if (this.inventory[3] != null) {
                                    this.inventory[3].field_77994_a += recipe2.slag.func_77946_l().field_77994_a;
                                } else {
                                    this.inventory[3] = recipe2.slag.func_77946_l();
                                }
                            }
                        }
                        this.processMax = 0;
                        this.active = false;
                    }
                    if ((recipe = this.getRecipe()) != null) {
                        this.processMax = this.process = recipe.time;
                        this.active = true;
                    }
                }
            } else if (this.active) {
                this.active = false;
            }
            if (this.burnTime <= 10 && this.getRecipe() != null && BlastFurnaceRecipe.isValidBlastFuel(this.inventory[1])) {
                this.burnTime += BlastFurnaceRecipe.getBlastFuelTime(this.inventory[1]);
                this.lastBurnTime = BlastFurnaceRecipe.getBlastFuelTime(this.inventory[1]);
                Utils.modifyInvStackSize(this.inventory, 1, -1);
                this.markContainingBlockForUpdate(null);
            }
            if (a != this.active) {
                this.func_70296_d();
                for (int yy = -1; yy <= 1; ++yy) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(xx, yy, zz));
                            if (tileEntity != null) {
                                tileEntity.func_70296_d();
                            }
                            this.markBlockForUpdate(this.func_174877_v().func_177982_a(xx, yy, zz), null);
                            this.field_145850_b.func_175641_c(this.func_174877_v().func_177982_a(xx, yy, zz), (Block)IEContent.blockStoneDevice, 1, this.active ? 1 : 0);
                        }
                    }
                }
            }
        }
    }

    public BlastFurnaceRecipe getRecipe() {
        BlastFurnaceRecipe recipe = BlastFurnaceRecipe.findRecipe(this.inventory[0]);
        if (recipe == null) {
            return null;
        }
        if ((this.inventory[0].field_77994_a >= (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).field_77994_a : 1) && this.inventory[2] == null || OreDictionary.itemMatches((ItemStack)this.inventory[2], (ItemStack)recipe.output, (boolean)true) && this.inventory[2].field_77994_a + recipe.output.field_77994_a <= this.getSlotLimit(2)) && (this.inventory[3] == null || OreDictionary.itemMatches((ItemStack)this.inventory[3], (ItemStack)recipe.slag, (boolean)true) && this.inventory[3].field_77994_a + recipe.slag.field_77994_a <= this.getSlotLimit(3))) {
            return recipe;
        }
        return null;
    }

    protected int getProcessSpeed() {
        return 1;
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        } else if (id == 1) {
            this.active = arg == 1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.process = nbt.func_74762_e("process");
        this.processMax = nbt.func_74762_e("processMax");
        this.active = nbt.func_74767_n("active");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.lastBurnTime = nbt.func_74762_e("lastBurnTime");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("lastBurnTime", this.lastBurnTime);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public void disassemble() {
        if (this.formed && !this.field_145850_b.field_72995_K) {
            BlockPos startPos = this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]);
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.field_145850_b.func_175625_s(startPos) instanceof TileEntityBlastFurnace)) {
                return;
            }
            for (int yy = -1; yy <= 1; ++yy) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        ItemStack s = null;
                        TileEntity te = this.field_145850_b.func_175625_s(startPos.func_177982_a(xx, yy, zz));
                        if (te instanceof TileEntityBlastFurnace) {
                            s = ((TileEntityBlastFurnace)te).getOriginalBlock();
                            ((TileEntityBlastFurnace)te).formed = false;
                        }
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockStoneDevice) {
                            this.field_145850_b.func_175698_g(startPos.func_177982_a(xx, yy, zz));
                        }
                        this.field_145850_b.func_175656_a(startPos.func_177982_a(xx, yy, zz), Block.func_149634_a((Item)s.func_77973_b()).func_176203_a(s.func_77952_i()));
                    }
                }
            }
        }
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return slot == 0 ? BlastFurnaceRecipe.findRecipe(stack) != null : slot == 1 && BlastFurnaceRecipe.isValidBlastFuel(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    protected FluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return null;
        }
        return super.getCapability(capability, facing);
    }
}

