/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class ItemChemthrower
extends ItemUpgradeableTool
implements IEItemInterfaces.IAdvancedFluidItem,
IShaderEquipableItem,
ITool {
    public ItemChemthrower() {
        super("chemthrower", 1, "CHEMTHROWER", new String[0]);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        FluidStack fs;
        ItemStack shader = this.getShaderItem(stack);
        if (shader != null) {
            list.add(TextFormatting.DARK_GRAY + shader.func_82833_r());
        }
        if ((fs = this.getFluid(stack)) != null) {
            TextFormatting rarity = fs.getFluid().getRarity() == EnumRarity.COMMON ? TextFormatting.GRAY : fs.getFluid().getRarity().field_77937_e;
            list.add(rarity + fs.getLocalizedName() + TextFormatting.GRAY + ": " + fs.amount + "/" + this.getCapacity(stack, 2000) + "mB");
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0]));
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemNBTHelper.setBoolean(stack, "ignite", !ItemNBTHelper.getBoolean(stack, "ignite"));
            }
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getFluid() != null) {
            int duration = this.func_77626_a(stack) - count;
            int consumed = Config.getInt("chemthrower_consumption");
            if (consumed * duration <= fs.amount) {
                float range;
                Vec3d v = player.func_70040_Z();
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas(fs.getFluid());
                float scatter = isGas ? 0.15f : 0.05f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).func_74767_n("focus")) {
                    range += 0.25f;
                    scatter -= 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ItemNBTHelper.getBoolean(stack, "ignite");
                for (int i = 0; i < split; ++i) {
                    Vec3d vecDir = v.func_72441_c(player.func_70681_au().nextGaussian() * (double)scatter, player.func_70681_au().nextGaussian() * (double)scatter, player.func_70681_au().nextGaussian() * (double)scatter);
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(player.field_70170_p, player, vecDir.field_72450_a * 0.25, vecDir.field_72448_b * 0.25, vecDir.field_72449_c * 0.25, fs.getFluid());
                    chem.field_70159_w = vecDir.field_72450_a * (double)range;
                    chem.field_70181_x = vecDir.field_72448_b * (double)range;
                    chem.field_70179_y = vecDir.field_72449_c * (double)range;
                    if (ignite) {
                        chem.func_70015_d(10);
                    }
                    if (player.field_70170_p.field_72995_K) continue;
                    player.field_70170_p.func_72838_d((Entity)chem);
                }
                if (count % 4 == 0) {
                    if (ignite) {
                        player.func_184185_a(IESounds.sprayFire, 0.5f, 1.5f);
                    } else {
                        player.func_184185_a(IESounds.spray, 0.5f, 0.75f);
                    }
                }
            } else {
                player.func_184597_cx();
            }
        } else {
            player.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            int duration = this.func_77626_a(stack) - timeLeft;
            fs.amount -= Config.getInt("chemthrower_consumption") * duration;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(stack, "Fluid");
            } else {
                ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack, 2000)) {
            fs.amount = this.getCapacity(stack, 2000);
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new IEItemFluidHandler(stack, 2000);
    }

    @Override
    public int getCapacity(ItemStack stack, int baseCapacity) {
        return baseCapacity + this.getUpgrades(stack).func_74762_e("capacity");
    }

    @Override
    public void setShaderItem(ItemStack stack, ItemStack shader) {
        ItemStack[] contained = this.getContainedItems(stack);
        contained[3] = shader;
        this.setContainedItems(stack, contained);
    }

    @Override
    public ItemStack getShaderItem(ItemStack stack) {
        ItemStack[] contained = this.getContainedItems(stack);
        return contained[3];
    }

    @Override
    public String getShaderType() {
        return "chemthrower";
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 0, 80, 32, "CHEMTHROWER", stack, true), new IESlot.Upgrades(container, invItem, 1, 100, 32, "CHEMTHROWER", stack, true), new IESlot.Upgrades(container, invItem, 2, 120, 32, "CHEMTHROWER", stack, true), new IESlot.Shader(container, invItem, 3, 150, 32, stack)};
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 4;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

