/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.ArcFurnace;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.BlastFurnace;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.BottlingMachine;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CokeOven;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.Crusher;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.Excavator;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.Fermenter;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.MetalPress;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.Refinery;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.Squeezer;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.util.IEventHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CraftTweakerHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        MineTweakerAPI.registerClass(BlastFurnace.class);
        MineTweakerAPI.registerClass(CokeOven.class);
        MineTweakerAPI.registerClass(Crusher.class);
        MineTweakerAPI.registerClass(Squeezer.class);
        MineTweakerAPI.registerClass(Fermenter.class);
        MineTweakerAPI.registerClass(Refinery.class);
        MineTweakerAPI.registerClass(ArcFurnace.class);
        MineTweakerAPI.registerClass(Excavator.class);
        MineTweakerAPI.registerClass(Excavator.MTMineralMix.class);
        MineTweakerAPI.registerClass(BottlingMachine.class);
        MineTweakerAPI.registerClass(MetalPress.class);
        try {
            MineTweakerImplementationAPI.onPostReload((IEventHandler)new ExcavatorEventHandler());
        }
        catch (Exception e) {
            IELogger.error("[CRITICAL] YOU ARE USING AN OUTDATED VERSION OF MINETWEAKER");
            IELogger.error("[CRITICAL] IE requires version 3.0.10b or later to function correctly!");
            IELogger.error("[CRITICAL] The use of an outdated version will cause major issues!!!!");
            e.printStackTrace();
        }
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        return MineTweakerMC.getItemStack((IItemStack)iStack);
    }

    public static Object toObject(IIngredient iStack) {
        if (iStack == null) {
            return null;
        }
        if (iStack instanceof IOreDictEntry) {
            return ((IOreDictEntry)iStack).getName();
        }
        if (iStack instanceof IItemStack) {
            return MineTweakerMC.getItemStack((IItemStack)((IItemStack)iStack));
        }
        if (iStack instanceof IngredientStack) {
            IIngredient ingr = (IIngredient)ReflectionHelper.getPrivateValue(IngredientStack.class, (Object)((IngredientStack)iStack), (String[])new String[]{"ingredient"});
            return CraftTweakerHelper.toObject(ingr);
        }
        return null;
    }

    public static Object[] toObjects(IIngredient[] iStacks) {
        Object[] oA = new Object[iStacks.length];
        for (int i = 0; i < iStacks.length; ++i) {
            oA[i] = CraftTweakerHelper.toObject(iStacks[i]);
        }
        return oA;
    }

    public static FluidStack toFluidStack(ILiquidStack iStack) {
        return MineTweakerMC.getLiquidStack((ILiquidStack)iStack);
    }

    public static class ExcavatorEventHandler
    implements IEventHandler<MineTweakerImplementationAPI.ReloadEvent> {
        public void handle(MineTweakerImplementationAPI.ReloadEvent event) {
            ExcavatorHandler.recalculateChances(false);
            if (ManualHelper.ieManualInstance != null) {
                ManualHelper.ieManualInstance.recalculateAllRecipes();
            }
        }
    }
}

