/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ManualUtils {
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof String) {
            return ManualUtils.compareToOreName(stack, (String)o);
        }
        if (o instanceof ItemStack) {
            if (!OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false)) {
                return false;
            }
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                return true;
            }
            if (((ItemStack)o).func_77942_o()) {
                return ((ItemStack)o).func_77978_p().equals((Object)stack.func_77978_p());
            }
            return true;
        }
        return false;
    }

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        for (int oid : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oid).equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static void drawTexturedRect(int x, int y, int w, int h, double ... uv) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(uv[0], uv[3]).func_181675_d();
        worldrenderer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(uv[1], uv[3]).func_181675_d();
        worldrenderer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(uv[1], uv[2]).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(uv[0], uv[2]).func_181675_d();
        tessellator.func_78381_a();
    }

    public static ArrayList<String> getPrimitiveSpellingCorrections(String query, String[] valid, int maxDistance) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : valid) {
            if (s == null || s.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s) >= maxDistance) continue;
            list.add(s);
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s0, String s1) {
                return ManualUtils.getSpellingDistanceBetweenStrings(s1, s0);
            }
        });
        return list;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase();
        target = target.toLowerCase();
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += targetWords[iWord].length() - queryWords[iWord].length();
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static void drawSplitString(FontRenderer fontRenderer, String string, int x, int y, int width, int colour) {
        fontRenderer.func_78265_b();
        fontRenderer.field_78304_r = colour;
        List list = fontRenderer.func_78271_c(string, width);
        FloatBuffer currentGLColor = BufferUtils.createFloatBuffer((int)16);
        for (String next : list) {
            int currentColour = fontRenderer.field_78304_r;
            GL11.glGetFloat((int)2816, (FloatBuffer)currentGLColor);
            if (currentGLColor.get(0) != (float)(currentColour >> 16 & 0xFF) / 255.0f || currentGLColor.get(1) != (float)(currentColour >> 8 & 0xFF) / 255.0f || currentGLColor.get(2) != (float)(currentColour & 0xFF) / 255.0f) {
                fontRenderer.field_78304_r = colour;
            }
            fontRenderer.func_175065_a(next, (float)x, (float)y, fontRenderer.field_78304_r, false);
            y += fontRenderer.field_78288_b;
        }
    }

    public static Tessellator tes() {
        return Tessellator.func_178181_a();
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(String path) {
        ManualUtils.mc().func_110434_K().func_110577_a(ManualUtils.getResource(path));
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static RenderItem renderItem() {
        return ManualUtils.mc().func_175599_af();
    }
}

