/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import shetiphian.core.common.RegistryHelper;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockEnderLinkChest;
import shetiphian.multistorage.common.block.BlockStoneStorage;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.item.ItemBlockEnderLinkChest;
import shetiphian.multistorage.common.item.ItemBlockStorageType;
import shetiphian.multistorage.common.item.ItemBlockVault;
import shetiphian.multistorage.common.item.ItemEnderBag;
import shetiphian.multistorage.common.misc.FluidConcrete;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;
import shetiphian.multistorage.common.tileentity.TileEntityChameleonDense;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLink;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;
import shetiphian.multistorage.common.tileentity.TileEntityJunkboxDense;
import shetiphian.multistorage.common.tileentity.TileEntityStacking;
import shetiphian.multistorage.common.tileentity.TileEntityStackingDense;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBase;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBroken;
import shetiphian.multistorage.common.tileentity.TileEntityVaultCorer;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;
import shetiphian.multistorage.common.tileentity.TileEntityVaultItem;
import shetiphian.multistorage.common.tileentity.TileEntityVaultRedstone;
import shetiphian.multistorage.common.tileentity.TileEntityVaultTank;

public class Registry {
    void doRegistration() {
        this.registerBlocks();
        this.registerItems();
        this.setTabIcon();
        this.registerCustomItemStacks();
    }

    private void registerBlocks() {
        if (Settings.INSTANCE.setup().addVaultBlocks) {
            Values.blockVault = RegistryHelper.registerBlock((Block)new BlockVault(), ItemBlockVault.class, (String)"vault", (String)"multistorage.vault", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityVaultBase.class, (String)"multistorage:vault.base");
            RegistryHelper.registerTileEntity(TileEntityVaultDoor.class, (String)"multistorage:vault.door");
            RegistryHelper.registerTileEntity(TileEntityVaultItem.class, (String)"multistorage:vault.item");
            RegistryHelper.registerTileEntity(TileEntityVaultRedstone.class, (String)"multistorage:vault.redstone");
            RegistryHelper.registerTileEntity(TileEntityVaultTank.class, (String)"multistorage:vault.tank");
            RegistryHelper.registerTileEntity(TileEntityVaultBroken.class, (String)"multistorage:vault.broken");
            RegistryHelper.registerTileEntity(TileEntityVaultCorer.class, (String)"multistorage:vault.corer");
            Values.fluidConcrete = (FluidConcrete)RegistryHelper.registerFluid((Fluid)new FluidConcrete());
            FluidContainerRegistry.registerFluidContainer((Fluid)Values.fluidConcrete, (ItemStack)new ItemStack(Values.blockVault, 1, 100), (ItemStack)new ItemStack(Items.field_151133_ar));
        }
        if (Settings.INSTANCE.setup().addStorageBlocks) {
            Values.blockStoneStorage = RegistryHelper.registerBlock((Block)new BlockStoneStorage(), ItemBlockStorageType.class, (String)"stone_storage", (String)"multistorage.storage.stone", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityStacking.class, (String)"multistorage:storage.stacking");
            RegistryHelper.registerTileEntity(TileEntityChameleon.class, (String)"multistorage:storage.hidden");
            RegistryHelper.registerTileEntity(TileEntityJunkbox.class, (String)"multistorage:storage.junkbox");
            RegistryHelper.registerTileEntity(TileEntityStackingDense.class, (String)"multistorage:storage.stacking_dense");
            RegistryHelper.registerTileEntity(TileEntityChameleonDense.class, (String)"multistorage:storage.hidden_dense");
            RegistryHelper.registerTileEntity(TileEntityJunkboxDense.class, (String)"multistorage:storage.junkbox_dense");
        }
        if (Settings.INSTANCE.setup().addEnderLinkChests) {
            Values.blockEnderLinkChest = RegistryHelper.registerBlock((Block)new BlockEnderLinkChest(), ItemBlockEnderLinkChest.class, (String)"ender_chest", (String)"multistorage.enderchest", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityEnderLink.class, (String)"multistorage:ender_chest.chest");
        }
        if (Settings.INSTANCE.setup().addEnderBags) {
            Values.itemEnderBag = RegistryHelper.registerItem((Item)new ItemEnderBag(), (String)"ender_bag", (String)"multistorage.enderbag");
        }
    }

    private void registerItems() {
    }

    private void setTabIcon() {
        if (Values.blockStoneStorage != null) {
            Values.tabMultiStorage.setIcon(new ItemStack(Values.blockStoneStorage, 1, 1));
            return;
        }
        if (Values.blockVault != null) {
            Values.tabMultiStorage.setIcon(new ItemStack(Values.blockVault, 1, 0));
            return;
        }
        if (Values.blockEnderLinkChest != null) {
            Values.tabMultiStorage.setIcon(new ItemStack(Values.blockEnderLinkChest, 1, 0));
        }
    }

    private void registerCustomItemStacks() {
        Item item;
        if (Values.blockStoneStorage != null) {
            item = Item.func_150898_a((Block)Values.blockStoneStorage);
            Values.stacks.put("stone_upgrade", this.iStack(item, 0));
            Values.stacks.put("stone_stacking", this.iStack(item, 1));
            Values.stacks.put("stone_stacking_dense", this.iStack(item, 2));
            Values.stacks.put("stone_chameleon", this.iStack(item, 3));
            Values.stacks.put("stone_chameleon_dense", this.iStack(item, 4));
            Values.stacks.put("stone_junkbox", this.iStack(item, 5));
            Values.stacks.put("stone_junkbox_dense", this.iStack(item, 6));
        }
        if (Values.blockEnderLinkChest != null) {
            item = Item.func_150898_a((Block)Values.blockEnderLinkChest);
            Values.stacks.put("enderchest", this.iStack(item, 0));
        }
        if (Values.blockVault != null) {
            item = Item.func_150898_a((Block)Values.blockVault);
            Values.stacks.put("vaultdoor", this.iStack(item, 0));
            Values.stacks.put("vaultcorer", this.iStack(item, 15));
            Values.stacks.put("vaultbucket", this.iStack(item, 100));
        }
        if (Values.itemEnderBag != null) {
            Values.stacks.put("enderlinkbag", this.iStack(Values.itemEnderBag, 0));
            Values.stacks.put("enderlinkbag_private", this.iStack(Values.itemEnderBag, 1));
            Values.stacks.put("enderbag", this.iStack(Values.itemEnderBag, 2));
        }
    }

    private ItemStack iStack(Item item, int metadata) {
        return new ItemStack(item, 1, metadata);
    }
}

