/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.enderlink.ChestInfoHelper;
import shetiphian.multistorage.common.enderlink.StackHelper;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLink;

public class BlockEnderLinkChest
extends Block
implements IColored {
    private static final PropertyBool PERSONAL = PropertyBool.func_177716_a((String)"personal");
    private static final AxisAlignedBB AABB_UD_CLOSED = new AxisAlignedBB(0.00625, 0.00625, 0.00625, 0.99375, 0.99375, 0.99375);
    private static final AxisAlignedBB AABB_UD_OPEN = new AxisAlignedBB(0.00625, 1.5, 0.00625, 0.99375, 1.7, 0.99375);
    private final float[] size = new float[]{0.001f, 0.999f};
    private final float[][] ring = new float[][]{{0.73125f, 0.79375f}, {0.65625f, 0.71875f}, {0.58125f, 0.64375f}};

    public BlockEnderLinkChest() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabMultiStorage);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
    }

    public ExtendedBlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{PERSONAL, Properties.StaticProperty}, new IUnlistedProperty[]{Properties.AnimationProperty});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(true));
        TileEntityEnderLink tile = this.getTile(world, pos);
        if (tile != null) {
            return state.func_177226_a((IProperty)PERSONAL, (Comparable)Boolean.valueOf(!tile.getOwnerID().equalsIgnoreCase("all")));
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityEnderLink();
    }

    private TileEntityEnderLink getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityEnderLink ? (TileEntityEnderLink)tile : null;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return AABB_UD_CLOSED;
        }
        return this.getTraceBox(world, pos, state);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        TileEntityEnderLink tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.isOpen()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, list, (AxisAlignedBB)AABB_UD_OPEN);
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, list, (AxisAlignedBB)this.getBounds(state));
    }

    private AxisAlignedBB getBounds(IBlockState state) {
        return AABB_UD_CLOSED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityEnderLink chestTile = this.getTile((IBlockAccess)world, pos);
        if (chestTile == null) {
            return false;
        }
        if (!player.func_70093_af()) {
            if (world.func_175623_d(pos.func_177984_a())) {
                player.openGui((Object)MultiStorage.INSTANCE, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null) {
            int index;
            if (world.field_72995_K) {
                return true;
            }
            if (chestTile.isPublic()) {
                for (ItemStack stack : Settings.INSTANCE.itemPersonal) {
                    if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                    chestTile.setOwner(player, currentItem.func_77946_l().func_77979_a(1));
                    if (!player.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    Function.syncTile((TileEntity)chestTile);
                    return true;
                }
            }
            if (!chestTile.canEdit(player)) {
                return true;
            }
            short capacity = ChestHelper.getCapacity(world, chestTile.getOwnerID(), chestTile.getCode());
            if (capacity < Settings.INSTANCE.chestSizeMax) {
                int newValue = 0;
                for (ItemStack stack : Settings.INSTANCE.itemSCapacityUpgrade) {
                    if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                    newValue = 3;
                    break;
                }
                if (newValue == 0 && capacity + 9 <= Settings.INSTANCE.chestSizeMax) {
                    for (ItemStack stack : Settings.INSTANCE.itemLCapacityUpgrade) {
                        if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                        newValue = 9;
                        break;
                    }
                }
                if (newValue > 0) {
                    ChestHelper.setCapacity(world, chestTile.getOwnerID(), chestTile.getCode(), (byte)(capacity + newValue));
                    if (!player.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    ChestInfoHelper.sendCapacityInfo(player, chestTile);
                    return true;
                }
            }
            boolean found = false;
            block3: for (index = 0; index < 16; index = (int)((byte)(index + 1))) {
                List results = Function.getOres((String)Function.dyeNamesWB[index]);
                for (ItemStack check : results) {
                    if (!OreDictionary.itemMatches((ItemStack)currentItem, (ItemStack)check, (boolean)true)) continue;
                    found = true;
                    break block3;
                }
            }
            if (found && chestTile.doColorRing(EnumDyeColor.func_176764_b((int)index), player)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --currentItem.field_77994_a;
                }
                return true;
            }
        }
        return false;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntityEnderLink tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.canEdit(player)) {
            return super.func_180647_a(state, player, world, pos);
        }
        return -1.0f;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this.func_180647_a(state, player, world, pos) == -1.0f) {
            return false;
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        super.removedByPlayer(state, world, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityEnderLink tile = this.getTile(world, pos);
        if (tile != null) {
            if (this.harvesters.get() != null && ((EntityPlayer)this.harvesters.get()).func_70093_af()) {
                ret.add(StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null));
                ItemStack personal = tile.getPersonalItem();
                if (personal != null) {
                    ret.add(personal);
                }
            } else {
                ret.add(StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem()));
            }
        } else {
            ret.add(new ItemStack((Block)this));
        }
        return ret;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityEnderLink tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            if (player != null && tile.getOwnerID().equalsIgnoreCase(player.func_110124_au().toString())) {
                return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
            }
            return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null);
        }
        return new ItemStack((Block)this);
    }

    private AxisAlignedBB getTraceBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntityEnderLink tile = this.getTile(world, pos);
        if (tile == null || !tile.rayTracing || tile.tracePart < 1 || tile.tracePart > 4) {
            return this.getBounds(state);
        }
        int index = tile.tracePart - 1;
        return new AxisAlignedBB((double)this.size[0], (double)this.ring[index][0], (double)this.size[0], (double)this.size[1], (double)this.ring[index][1], (double)this.size[1]);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d startVec, Vec3d endVec) {
        this.getBounds(state);
        RayTraceResult original = super.func_180636_a(state, world, pos, startVec, endVec);
        TileEntityEnderLink tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            RayTraceResult areaHit = null;
            tile.rayTracing = true;
            double hitDist = 100.0;
            for (int codeBand = 0; codeBand < 4; codeBand = (int)((byte)(codeBand + 1))) {
                tile.tracePart = codeBand;
                RayTraceResult ringHit = this.func_185503_a(pos, startVec, endVec, this.getTraceBox((IBlockAccess)world, pos, state));
                if (ringHit == null) continue;
                ringHit.subHit = codeBand;
                double ringDist = ringHit.field_72307_f.func_72436_e(startVec);
                if (!(ringDist < hitDist)) continue;
                hitDist = ringDist;
                areaHit = ringHit;
            }
            if (areaHit != null && areaHit.subHit > 0) {
                tile.tracePart = areaHit.subHit;
                return areaHit;
            }
            tile.rayTracing = false;
        }
        return original;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderLink tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile(data.world, data.pos)) != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Settings.INSTANCE.colorValues[value];
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntityEnderLink tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.isOpen()) {
            for (int particle = 0; particle < 3; ++particle) {
                double shift = (double)rand.nextInt(2) * 2.0 - 1.0;
                double xCoord = (double)pos.func_177958_n() + 0.5 + 0.25 * shift;
                double yCoord = (double)pos.func_177956_o() + rand.nextDouble() + 0.5;
                double zCoord = (double)pos.func_177952_p() + 0.5 + 0.25 * shift;
                double xOffset = rand.nextDouble() * shift;
                double yOffset = (rand.nextDouble() - 0.5) * 0.125;
                double zOffset = rand.nextDouble() * shift;
                world.func_175688_a(EnumParticleTypes.PORTAL, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, new int[0]);
            }
        }
    }
}

