/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.enderlink.StackHelper;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLink;

public class ItemBlockEnderLinkChest
extends ItemBlockMulti
implements IColored {
    public ItemBlockEnderLinkChest(Block block) {
        super(block, "BlockEnderLinkChest", Values.nameMapper);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (String code : StackHelper.BASECODES) {
            list.add(StackHelper.create(item, code, null));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true) || stack.func_77952_i() < 0) {
            return false;
        }
        ItemStack personal = StackHelper.getPersonalItem(stack);
        if (stack.func_77952_i() > 1) {
            stack.func_77964_b(personal != null ? 1 : 0);
        }
        if (world.func_180495_p(pos).func_177230_c() == Values.blockEnderLinkChest) {
            Values.blockEnderLinkChest.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityEnderLink)) {
                return false;
            }
            String code = StackHelper.getCode(stack);
            while (code.length() < 3) {
                code = "0" + code;
            }
            ((TileEntityEnderLink)te).setCode(code);
            if (personal != null) {
                ((TileEntityEnderLink)te).setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerUUID(stack), personal);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        tooltip.add(" " + Localization.get((String)"info.multistorage.chest.code.txt") + " " + StackHelper.getCode(stack));
        String owner = StackHelper.getOwnerName(stack);
        if (!owner.equals("all")) {
            tooltip.add(" \u00a7b[-" + owner + "-]\u00a7r");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && data.stack != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Settings.INSTANCE.colorValues[value];
        }
        return 0xFFFFFF;
    }

    protected void addToNameMap() {
        this.add(0, "", "enderchest_public", "public");
        this.add(1, "", "enderchest_private", "private");
    }
}

