/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.IContainerCallback;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;

public abstract class TileEntityStorageBase
extends TileEntityBase
implements IInventory,
IContainerCallback {
    protected InventoryInternal inventory = new InventoryInternal((TileEntity)this, "internal", this.getChestSize());
    InvWrapper inventoryWrapper = new InvWrapper((IInventory)this.inventory);
    private int numUsingPlayers;
    private EnumFacing facing;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("facing", this.getFacing().func_176610_l());
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.facing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
    }

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.writeToNBT(nbtTag, "items");
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "Items");
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public EnumFacing getFacing() {
        return this.facing != null ? this.facing : EnumFacing.NORTH;
    }

    public void dropItems() {
        for (ItemStack itemStack : this.inventory.getContents()) {
            if (itemStack == null) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)itemStack);
        }
        Function.updateLighting((TileEntity)this);
        this.func_145831_w().func_175666_e(this.field_174879_c, this.func_145838_q());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IInventory getChest() {
        return this.inventory;
    }

    protected abstract int getChestSize();

    public boolean canInteractWith(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void onContainerOpen(EntityPlayer player) {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        if (!player.func_175149_v()) {
            ++this.numUsingPlayers;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
        }
    }

    public void onContainerClosed(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.numUsingPlayers;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
        }
    }

    public int func_70302_i_() {
        return this.getChestSize();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        return this.inventory.func_70298_a(slotId, amount);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inventory.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        this.inventory.func_70299_a(slotId, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return this.inventory.func_94041_b(slotId, stack);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

