/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.item.ItemBlockVault;
import shetiphian.multistorage.common.misc.FluidConcrete;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBase;
import shetiphian.multistorage.common.tileentity.TileEntityVaultItem;

public class TileEntityVaultCorer
extends TileEntityBase
implements ITickable {
    private InventoryInternal invFuel = new InventoryInternal((TileEntity)this, "invFuel", 1);
    private InventoryInternal invItems = new InventoryInternal((TileEntity)this, "invItems", 4, 1);
    private EnumFacing facing = EnumFacing.DOWN;
    private int progress;
    private int charge;
    private int burnTime;
    private int burnValue;
    private EnumStage stage = EnumStage.IDLE;
    @SideOnly(value=Side.CLIENT)
    private TRSRTransformation transform;
    @SideOnly(value=Side.CLIENT)
    private TRSRTransformation drilltransform;
    private List<String> group = new ArrayList<String>();

    protected void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        this.invFuel.writeToNBT(nbtTag);
        this.invItems.writeToNBT(nbtTag);
        nbtTag.func_74768_a("charge", this.charge);
        nbtTag.func_74768_a("burnTime", this.burnTime);
        nbtTag.func_74768_a("burnValue", this.burnValue);
    }

    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        this.invFuel.readFromNBT(nbtTag);
        this.invItems.readFromNBT(nbtTag);
        this.charge = nbtTag.func_74762_e("charge");
        this.burnTime = nbtTag.func_74762_e("burnTime");
        this.burnValue = nbtTag.func_74762_e("burnValue");
    }

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("facing", this.facing.func_176610_l());
        nbtTag.func_74778_a("stage", this.stage.toString());
        nbtTag.func_74768_a("progress", this.progress);
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.facing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
        this.stage = EnumStage.byName(nbtTag.func_74779_i("stage"));
        this.progress = nbtTag.func_74762_e("progress");
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation getTransform() {
        if (this.transform == null) {
            Matrix4f matrix = this.getMatrix(this.facing);
            matrix.setScale(0.5f);
            Vector3f vector3f = new Vector3f(0.5001f, 0.5001f, 0.5001f);
            matrix.setTranslation(vector3f);
            this.transform = new TRSRTransformation(matrix);
        }
        return this.transform;
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation getDrillTransform() {
        if (this.drilltransform == null) {
            Matrix4f matrix = this.getMatrix(this.facing.func_176734_d());
            matrix.setScale(0.5f);
            Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
            matrix.setTranslation(vector3f);
            this.drilltransform = new TRSRTransformation(matrix);
        }
        return this.drilltransform;
    }

    @SideOnly(value=Side.CLIENT)
    private Matrix4f getMatrix(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return ModelRotation.X0_Y0.getMatrix();
            }
            case UP: {
                return ModelRotation.X180_Y0.getMatrix();
            }
            case SOUTH: {
                return ModelRotation.X270_Y180.getMatrix();
            }
            case NORTH: {
                return ModelRotation.X270_Y0.getMatrix();
            }
            case WEST: {
                return ModelRotation.X270_Y270.getMatrix();
            }
            case EAST: {
                return ModelRotation.X270_Y90.getMatrix();
            }
        }
        return ModelRotation.X0_Y0.getMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getGroup() {
        if (this.group.isEmpty()) {
            this.group.add("riboncable");
            this.group.add("fuelport");
            this.group.add("exhaust");
            this.group.add("curcuits");
            this.group.add("heatsink");
            this.group.add("bolts");
            this.group.add("chassy");
        }
        return this.group;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack fuel = this.invFuel.func_70301_a(0);
        ItemStack[] items = this.invItems.getContents();
        if (this.progress < 0 && this.stage != EnumStage.FINISHED) {
            this.setStage(EnumStage.FINISHED);
        }
        switch (this.stage) {
            case IDLE: {
                if (fuel == null || items[0] == null || items[1] == null || items[2] != null || items[3] != null) break;
                this.setStage(this.charge < 800 ? EnumStage.CHARGING : EnumStage.WORKING);
                break;
            }
            case CHARGING: {
                if (this.charge + this.progress >= 800) {
                    this.setStage(EnumStage.WORKING);
                    break;
                }
                if (this.burnTime > 0) {
                    --this.burnTime;
                    ++this.charge;
                    break;
                }
                int value = Math.max(TileEntityFurnace.func_145952_a((ItemStack)fuel) / 4, 1);
                if (fuel != null && value > 0) {
                    this.burnValue = value;
                    this.burnTime = value;
                    --fuel.field_77994_a;
                    if (fuel.field_77994_a < 1) {
                        this.invFuel.func_70299_a(0, fuel.func_77973_b().getContainerItem(fuel));
                    }
                    this.func_70296_d();
                    break;
                }
                this.setStage(EnumStage.IDLE);
                break;
            }
            case WORKING: {
                if (items[0] == null || items[1] == null || items[2] != null || items[3] != null) {
                    this.setStage(EnumStage.IDLE);
                } else if (this.progress + this.charge < 800) {
                    this.setStage(EnumStage.CHARGING);
                } else if (this.progress < 800) {
                    this.charge = MathHelper.func_76125_a((int)(this.charge - 1), (int)0, (int)800);
                    ++this.progress;
                } else {
                    TileEntityVaultBase tile;
                    BlockPos wallPos = this.func_174877_v().func_177972_a(this.facing);
                    IBlockState state = this.func_145831_w().func_180495_p(wallPos);
                    if (state.func_177230_c() instanceof BlockVault && (tile = ((BlockVault)state.func_177230_c()).getTile((IBlockAccess)this.func_145831_w(), wallPos)) != null) {
                        List<BlockPos> doorList = tile.getDoorList();
                        BlockVault.EnumType newType = FluidConcrete.getTypeFromStack(items[0]);
                        if (newType != null) {
                            if (tile instanceof TileEntityVaultItem) {
                                ((TileEntityVaultItem)tile).dropContent();
                            }
                            BlockVault.EnumType oldType = BlockVault.getEnumType(state);
                            this.invItems.func_70299_a(2, new ItemStack(Values.blockVault, 1, oldType.getValue() + 20));
                            this.invItems.func_70299_a(0, null);
                            Function.setBlock((World)this.func_145831_w(), (BlockPos)wallPos, (IBlockState)state.func_177226_a(BlockVault.VARIANT, (Comparable)((Object)newType)), (boolean)true);
                            this.func_145831_w().func_184133_a(null, wallPos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            tile = ((BlockVault)state.func_177230_c()).getTile((IBlockAccess)this.func_145831_w(), wallPos);
                            if (tile != null) {
                                tile.setDoorList(doorList);
                            }
                            if (items[1].func_77973_b() instanceof ItemBlockVault) {
                                this.invItems.func_70299_a(3, new ItemStack(Items.field_151133_ar));
                                this.invItems.func_70299_a(1, null);
                            } else if (items[1].func_77973_b() instanceof IFluidContainerItem) {
                                ((IFluidContainerItem)items[1].func_77973_b()).drain(items[1], 1000, true);
                                this.invItems.func_70299_a(3, items[1]);
                                this.invItems.func_70299_a(1, null);
                            }
                        }
                    }
                    this.progress = -200;
                    this.stage = EnumStage.FINISHED;
                }
                Function.syncTile((TileEntity)this);
                break;
            }
            case FINISHED: {
                if (this.progress < 0) {
                    ++this.progress;
                } else {
                    this.progress = 0;
                    this.stage = EnumStage.IDLE;
                }
                Function.syncTile((TileEntity)this);
            }
        }
    }

    public EnumStage getStage() {
        return this.stage;
    }

    private void setStage(EnumStage stage) {
        this.stage = stage;
        Function.syncTile((TileEntity)this);
    }

    public InventoryInternal getInvFuel() {
        return this.invFuel;
    }

    public InventoryInternal getInvItems() {
        return this.invItems;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int value) {
        this.progress = value;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int value) {
        this.charge = value;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int value) {
        this.burnTime = value;
    }

    public int getBurnValue() {
        return this.burnValue;
    }

    public void setBurnValue(int value) {
        this.burnValue = value;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int graphicSize) {
        return this.progress == 0 ? 0 : MathHelper.func_76125_a((int)this.progress, (int)0, (int)800) * graphicSize / 800;
    }

    @SideOnly(value=Side.CLIENT)
    public int getChargeScaled(int graphicSize) {
        return this.charge == 0 ? 0 : this.charge * graphicSize / 800;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuelProgressScaled(int graphicSize) {
        return this.burnTime == 0 ? 0 : MathHelper.func_76125_a((int)(this.burnTime * graphicSize / this.burnValue), (int)1, (int)graphicSize);
    }

    public void dropContent() {
        for (ItemStack stack : this.invFuel.getContents()) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)stack);
        }
        for (ItemStack stack : this.invItems.getContents()) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)stack);
        }
    }

    public static boolean isItemCore(ItemStack stack) {
        return FluidConcrete.getTypeFromStack(stack) != null;
    }

    public static boolean isItemConcrete(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlockVault) {
            return stack.func_77952_i() == 100;
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
            return fluidStack != null && fluidStack.containsFluid(new FluidStack((Fluid)Values.fluidConcrete, 1000));
        }
        return false;
    }

    public static enum EnumStage {
        IDLE,
        CHARGING,
        WORKING,
        FINISHED;


        private static EnumStage byName(String name) {
            for (EnumStage value : EnumStage.values()) {
                if (!value.toString().equalsIgnoreCase(name)) continue;
                return value;
            }
            return IDLE;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

