/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.multistorage.common.block.VaultHelper;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBase;
import shetiphian.multistorage.common.tileentity.VaultAccess;

public class TileEntityVaultDoor
extends TileEntityVaultBase
implements ITickable {
    public EnumFacing direction;
    public EnumDoorPart vaultDoorType;
    public String vaultName = "null";
    public String vaultSize = "null";
    public VaultAccess vaultAccess = new VaultAccess();
    public BlockPos location;
    public byte doorSection;
    private short delay;
    private AxisAlignedBB vaultBounds;
    private Cache<UUID, Byte> cacheIntruder = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    @SideOnly(value=Side.CLIENT)
    private TRSRTransformation transform;
    private List<String> group = new ArrayList<String>();

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74778_a("direction", this.direction == null ? "north" : this.direction.func_176610_l());
        nbtTag.func_74774_a("vaultDoorPart", this.vaultDoorType == null ? (byte)0 : this.vaultDoorType.getValue());
        nbtTag.func_74778_a("vaultName", this.vaultName);
        nbtTag.func_74778_a("vaultSize", this.vaultSize);
        nbtTag.func_74782_a("vaultAccess", (NBTBase)this.vaultAccess.serialize());
        nbtTag.func_74782_a("location", (NBTBase)this.toNBT(this.location == null ? this.func_174877_v() : this.location));
        nbtTag.func_74774_a("doorSection", this.doorSection);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.direction = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("direction"));
        this.vaultDoorType = EnumDoorPart.byValue(nbtTag.func_74771_c("vaultDoorPart"));
        this.vaultName = nbtTag.func_74779_i("vaultName");
        this.vaultSize = nbtTag.func_74779_i("vaultSize");
        this.vaultAccess.deserialize(nbtTag.func_74775_l("vaultAccess"));
        this.location = this.fromNBT(nbtTag.func_74775_l("location"));
        this.doorSection = nbtTag.func_74771_c("doorSection");
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K || this.vaultDoorType == EnumDoorPart.NOTSET || this.vaultDoorType == EnumDoorPart.FILLER || !this.vaultAccess.isDefenceEnabled()) {
            return;
        }
        this.delay = (short)(this.delay + 1);
        if (this.delay < 100) {
            return;
        }
        this.delay = 0;
        if (this.vaultBounds == null) {
            String[] split = this.vaultSize.split(":");
            try {
                this.vaultBounds = new AxisAlignedBB((double)Integer.parseInt(split[0]), (double)Integer.parseInt(split[1]), (double)Integer.parseInt(split[2]), (double)Integer.parseInt(split[3]), (double)Integer.parseInt(split[4]), (double)Integer.parseInt(split[5]));
                this.vaultBounds = this.vaultBounds.func_72314_b(-0.75, -0.75, -0.75);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.vaultBounds == null) {
            return;
        }
        List players = this.func_145831_w().func_72872_a(EntityPlayer.class, this.vaultBounds);
        for (EntityPlayer player : players) {
            BlockPos posOut = this.func_174877_v().func_177972_a(this.direction.func_176734_d());
            if (this.vaultAccess.canUseVault(player)) continue;
            if (!this.vaultAccess.isDefenceKill() || this.cacheIntruder.getIfPresent((Object)player.func_110124_au()) == null) {
                if (this.vaultAccess.isDefenceKill()) {
                    this.cacheIntruder.put((Object)player.func_110124_au(), (Object)1);
                }
                Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"notice.multistorage.vault.intruder.removed.txt"));
                VaultHelper.vaultLog(this, player, Localization.get((String)"info.multistorage.vault.intruder.removed.txt"), false);
                player.func_70634_a((double)posOut.func_177958_n() + 0.5, (double)posOut.func_177956_o(), (double)posOut.func_177952_p() + 0.5);
                continue;
            }
            this.cacheIntruder.put((Object)player.func_110124_au(), (Object)1);
            Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"notice.multistorage.vault.intruder.killed.txt"));
            VaultHelper.vaultLog(this, player, Localization.get((String)"info.multistorage.vault.intruder.killed.txt"), false);
            player.func_70606_j(0.0f);
            this.func_145831_w().func_72960_a((Entity)player, (byte)2);
            player.func_110142_aN().func_94549_h();
            player.field_71071_by.func_70436_m();
            this.func_145831_w().func_72960_a((Entity)player, (byte)3);
        }
    }

    public String getLocationString() {
        return this.location.func_177958_n() + ":" + this.location.func_177956_o() + ":" + this.location.func_177952_p();
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation getTransform() {
        if (this.transform == null) {
            Matrix4f matrix = new Matrix4f(TRSRTransformation.getMatrix((EnumFacing)this.direction));
            matrix.setScale(0.5f);
            Vector3f vector3f = new Vector3f(0.5001f, 0.5001f, 0.5001f);
            matrix.setTranslation(vector3f);
            this.transform = new TRSRTransformation(matrix);
        }
        return this.transform;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getGroup() {
        if (this.group.isEmpty()) {
            TileEntity tileEntity;
            EnumDoorPart part = this.vaultDoorType;
            if (part == EnumDoorPart.FILLER && this.location != null && (tileEntity = this.func_145831_w().func_175625_s(this.location)) instanceof TileEntityVaultDoor) {
                part = ((TileEntityVaultDoor)tileEntity).vaultDoorType;
            }
            if (part == EnumDoorPart.CONTROLLER_2X) {
                this.group.add("2x2_" + (this.doorSection + 1));
            } else if (part == EnumDoorPart.CONTROLLER_3X) {
                this.group.add("3x3_" + (this.doorSection + 1));
            } else {
                return Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
            }
        }
        return this.group;
    }

    public static enum EnumDoorPart {
        NOTSET(0),
        FILLER(1),
        CONTROLLER_2X(2),
        CONTROLLER_3X(3);

        private static final EnumDoorPart[] array;
        private final byte value;

        private EnumDoorPart(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumDoorPart byValue(int value) {
            EnumDoorPart type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? NOTSET : type;
        }

        static {
            array = new EnumDoorPart[4];
            for (EnumDoorPart value : EnumDoorPart.values()) {
                if (array[value.getValue()] != null) continue;
                EnumDoorPart.array[value.getValue()] = value;
            }
        }
    }
}

