/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.modintegration.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockStoneStorage;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.enderlink.ChestInfoHelper;
import shetiphian.multistorage.common.tileentity.IVaultWall;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLink;
import shetiphian.multistorage.modintegration.terraqueous.BlockCloudStorage;

public class WailaDataProvider
implements IWailaDataProvider {
    public static WailaDataProvider INSTANCE = new WailaDataProvider();

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getBlock().getPickBlock(accessor.getBlockState(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile instanceof IVaultWall) {
            List<String> lines = ((IVaultWall)tile).getExtraWailaInfo(accessor.getNBTData());
            for (String line : lines) {
                tooltip.add(line);
            }
        } else if (tile instanceof TileEntityEnderLink) {
            ChestInfoHelper.wailaGetTankInfo(tooltip, (TileEntityEnderLink)tile);
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        if (Values.blockEnderLinkChest != null) {
            registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, TileEntityEnderLink.class);
        }
        if (Values.blockCloudStorage != null) {
            registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockCloudStorage.class);
        }
        if (Values.blockStoneStorage != null) {
            registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockStoneStorage.class);
        }
        if (Values.blockVault != null) {
            registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, IVaultWall.class);
            registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockVault.class);
        }
    }
}

