/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.handler.DropoffHandler;
import vazkii.quark.base.lib.LibObfuscation;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.network.message.MessageDropoff;
import vazkii.quark.base.network.message.MessageRestock;
import vazkii.quark.management.client.gui.GuiButtonChest;

public class ChestButtons
extends Feature {
    boolean deposit;
    boolean smartDeposit;
    boolean restock;

    @Override
    public void setupConfig() {
        this.deposit = this.loadPropBool("Enable Deposit Button", "", true);
        this.smartDeposit = this.loadPropBool("Enable Smart Deposit Button", "", true);
        this.restock = this.loadPropBool("Enable Restock Button", "", true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer guiInv = (GuiContainer)event.getGui();
            Container container = guiInv.field_147002_h;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            boolean accept = guiInv instanceof GuiChest;
            for (Slot s : container.field_75151_b) {
                IInventory inv = s.field_75224_c;
                if (inv == null || !DropoffHandler.isValidChest((EntityPlayer)player, inv)) continue;
                accept = true;
                break;
            }
            if (!accept) {
                return;
            }
            int guiLeft = (Integer)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiInv, (String[])LibObfuscation.GUI_LEFT);
            int guiTop = (Integer)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)guiInv, (String[])LibObfuscation.GUI_TOP);
            for (Slot s : container.field_75151_b) {
                if (s.field_75224_c != player.field_71071_by || s.getSlotIndex() != 9) continue;
                if (this.restock) {
                    event.getButtonList().add(new GuiButtonChest<GuiContainer>(guiInv, GuiButtonChest.Action.RESTOCK, 13211, guiLeft - 18, guiTop + s.field_75221_f));
                }
                if (this.deposit) {
                    event.getButtonList().add(new GuiButtonChest<GuiContainer>(guiInv, GuiButtonChest.Action.DEPOSIT, 13212, guiLeft - 18, guiTop + s.field_75221_f + 18));
                }
                if (!this.smartDeposit) break;
                event.getButtonList().add(new GuiButtonChest<GuiContainer>(guiInv, GuiButtonChest.Action.SMART_DEPOSIT, 13213, guiLeft - 18, guiTop + s.field_75221_f + 36));
                break;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiButtonChest) {
            GuiButtonChest buttonChest = (GuiButtonChest)event.getButton();
            GuiButtonChest.Action action = buttonChest.action;
            switch (action) {
                case SMART_DEPOSIT: {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDropoff(true, true));
                    break;
                }
                case DEPOSIT: {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDropoff(false, true));
                    break;
                }
                case RESTOCK: {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageRestock());
                }
            }
            event.setCanceled(true);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

