/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartCommandBlock;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;

public class MinecartInteraction
extends Feature {
    Map<Item, Function<EntityMinecartEmpty, EntityMinecart>> inserters = new HashMap<Item, Function<EntityMinecartEmpty, EntityMinecart>>();
    boolean enableCommandAndSpawner;

    @Override
    public void setupConfig() {
        this.enableCommandAndSpawner = this.loadPropBool("Enable Command Block and Mob Spawner", "", true);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150486_ae), e -> new EntityMinecartChest(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v));
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150335_W), e -> new EntityMinecartTNT(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v));
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150460_al), e -> new EntityMinecartFurnace(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v));
        this.inserters.put(Item.func_150898_a((Block)Blocks.field_150438_bZ), e -> new EntityMinecartHopper(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v));
        if (this.enableCommandAndSpawner) {
            this.inserters.put(Item.func_150898_a((Block)Blocks.field_150483_bI), e -> new EntityMinecartCommandBlock(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v));
            this.inserters.put(Item.func_150898_a((Block)Blocks.field_150474_ac), e -> new EntityMinecartMobSpawner(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v));
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        if (target instanceof EntityMinecartEmpty && target.func_184188_bt().isEmpty()) {
            EntityPlayer player = event.getEntityPlayer();
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (stack == null || !this.inserters.containsKey(stack.func_77973_b())) {
                stack = player.func_184592_cb();
                hand = EnumHand.OFF_HAND;
            }
            if (stack != null && this.inserters.containsKey(stack.func_77973_b())) {
                player.func_184609_a(hand);
                if (!event.getWorld().field_72995_K) {
                    target.func_70106_y();
                    event.getWorld().func_72838_d((Entity)this.inserters.get(stack.func_77973_b()).apply((EntityMinecartEmpty)target));
                    event.setCanceled(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                        if (stack.field_77994_a <= 0) {
                            player.func_184611_a(hand, (ItemStack)null);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

