/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.lib.LibObfuscation;
import vazkii.quark.base.module.Feature;
import vazkii.quark.vanity.client.layer.LayerBetterElytra;
import vazkii.quark.vanity.recipe.ElytraDyingRecipe;

public class DyableElytra
extends Feature {
    public static final String TAG_ELYTRA_DYE = "quark:elytraDye";

    @Override
    public void init(FMLInitializationEvent event) {
        GameRegistry.addRecipe((IRecipe)new ElytraDyingRecipe());
        RecipeSorter.register((String)"quark:elytraDying", ElytraDyingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitClient(FMLPostInitializationEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager manager = mc.func_175598_ae();
        Map renders = manager.getSkinMap();
        for (RenderPlayer render : renders.values()) {
            this.messWithRender(render);
        }
        mc.getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                int color = ItemNBTHelper.getInt((ItemStack)stack, (String)DyableElytra.TAG_ELYTRA_DYE, (int)-1);
                if (color == -1 || color == 15) {
                    return -1;
                }
                return ItemDye.field_150922_c[color];
            }
        }, new Item[]{Items.field_185160_cR});
    }

    @SideOnly(value=Side.CLIENT)
    private void messWithRender(RenderPlayer render) {
        List list = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)render, (String[])LibObfuscation.LAYER_RENDERERS);
        LayerRenderer remove = null;
        for (LayerRenderer layer : list) {
            if (!(layer instanceof LayerElytra)) continue;
            remove = layer;
            break;
        }
        list.remove(remove);
        list.add(new LayerBetterElytra(render));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        int color;
        EnumDyeColor dye;
        ItemStack stack = event.getItemStack();
        if (stack != null && stack.func_77973_b() == Items.field_185160_cR && (dye = EnumDyeColor.func_176766_a((int)(color = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_ELYTRA_DYE, (int)15)))) != EnumDyeColor.WHITE) {
            event.getToolTip().add(I18n.func_135052_a((String)"quark.dyedElytra", (Object[])new Object[]{I18n.func_135052_a((String)("quark.dye." + dye.func_176762_d()), (Object[])new Object[0])}));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

