/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.quark.base.client.gui.GuiButtonTranslucent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.vanity.client.emotes.EmoteCheer;
import vazkii.quark.vanity.client.emotes.EmoteClap;
import vazkii.quark.vanity.client.emotes.EmoteFacepalm;
import vazkii.quark.vanity.client.emotes.EmoteHeadbang;
import vazkii.quark.vanity.client.emotes.EmoteNo;
import vazkii.quark.vanity.client.emotes.EmotePoint;
import vazkii.quark.vanity.client.emotes.EmoteSalute;
import vazkii.quark.vanity.client.emotes.EmoteShrug;
import vazkii.quark.vanity.client.emotes.EmoteWave;
import vazkii.quark.vanity.client.emotes.EmoteYes;
import vazkii.quark.vanity.client.emotes.base.EmoteHandler;
import vazkii.quark.vanity.client.emotes.base.EmoteKeybinds;
import vazkii.quark.vanity.client.emotes.base.ModelAccessor;
import vazkii.quark.vanity.client.gui.GuiButtonEmote;
import vazkii.quark.vanity.command.CommandEmote;

public class EmoteSystem
extends Feature {
    private static final int EMOTE_BUTTON_START = 1800;
    static boolean emotesVisible = false;
    private boolean enableKeybinds;

    @Override
    public void setupConfig() {
        this.enableKeybinds = this.loadPropBool("Enable Keybinds", "Should keybinds for emotes be generated? (They're all unbound by default)", true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        Tween.registerAccessor(ModelBiped.class, new ModelAccessor());
        MinecraftForge.EVENT_BUS.register((Object)new EmoteHandler.TickHandler());
        EmoteHandler.emoteMap.put("wave", EmoteWave.class);
        EmoteHandler.emoteMap.put("salute", EmoteSalute.class);
        EmoteHandler.emoteMap.put("yes", EmoteYes.class);
        EmoteHandler.emoteMap.put("no", EmoteNo.class);
        EmoteHandler.emoteMap.put("cheer", EmoteCheer.class);
        EmoteHandler.emoteMap.put("clap", EmoteClap.class);
        EmoteHandler.emoteMap.put("point", EmotePoint.class);
        EmoteHandler.emoteMap.put("shrug", EmoteShrug.class);
        EmoteHandler.emoteMap.put("facepalm", EmoteFacepalm.class);
        EmoteHandler.emoteMap.put("headbang", EmoteHeadbang.class);
        if (this.enableKeybinds) {
            EmoteKeybinds.init();
        }
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandEmote());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiChat) {
            List list = event.getButtonList();
            list.add(new GuiButtonTranslucent(1800, gui.field_146294_l - 100, gui.field_146295_m - 40, 100, 20, I18n.func_135052_a((String)"quark.gui.emotes", (Object[])new Object[0])));
            int size = EmoteHandler.emoteMap.size() - 1;
            int i = 0;
            for (String key : EmoteHandler.emoteMap.keySet()) {
                int x = gui.field_146294_l - 100;
                int y = gui.field_146295_m - 61 - 21 * (size - i);
                GuiButtonEmote button = new GuiButtonEmote(1800 + i + 1, x, y, key);
                button.field_146125_m = emotesVisible;
                button.field_146124_l = emotesVisible;
                list.add(button);
                ++i;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        GuiButton button = event.getButton();
        if (button.field_146127_k == 1800) {
            event.getGui();
            List list = event.getButtonList();
            for (GuiButton b : list) {
                if (!(b instanceof GuiButtonEmote)) continue;
                b.field_146125_m = !b.field_146125_m;
                b.field_146124_l = !b.field_146124_l;
            }
            emotesVisible = !emotesVisible;
        } else if (button instanceof GuiButtonEmote) {
            String emote = ((GuiButtonEmote)button).emote;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/emote " + emote);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71415_G && this.enableKeybinds) {
            for (KeyBinding key : EmoteKeybinds.emoteKeys.keySet()) {
                if (!key.func_151470_d()) continue;
                String emote = EmoteKeybinds.emoteKeys.get(key);
                mc.field_71439_g.func_71165_d("/emote " + emote);
                return;
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }
}

