/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.arl.block.BlockModSlab;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.util.RecipeHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockBiotite;
import vazkii.quark.world.block.BlockBiotiteOre;
import vazkii.quark.world.block.BlockBiotiteSlab;
import vazkii.quark.world.block.BlockBiotiteStairs;
import vazkii.quark.world.item.ItemBiotite;
import vazkii.quark.world.world.BiotiteGenerator;

public class Biotite
extends Feature {
    public static Block biotite_ore;
    public static Block biotite_block;
    public static Item biotite;
    public static boolean generateNatually;
    boolean generateByDragon;
    boolean enableWalls;
    int clusterSize;
    int clusterCount;
    int generationDelay;
    int clustersPerTick;

    @Override
    public void setupConfig() {
        this.enableWalls = this.loadPropBool("Enable walls", "", true);
        generateNatually = this.loadPropBool("Generate naturally", "", false);
        this.generateByDragon = this.loadPropBool("Generate by dragon kill", "", true);
        this.clusterSize = this.loadPropInt("Cluster size", "", 14);
        this.clusterCount = this.loadPropInt("Cluster count for natural generation", "", 16);
        this.generationDelay = this.loadPropInt("Generation delay on dragon death", "", 1);
        this.clustersPerTick = this.loadPropInt("Clusters generated per dragon death tick", "", 16);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        biotite_ore = new BlockBiotiteOre();
        biotite_block = new BlockBiotite();
        biotite = new ItemBiotite();
        BlockBiotiteSlab singleSlab = new BlockBiotiteSlab(false);
        BlockModSlab.initSlab((Block)biotite_block, (int)0, (BlockModSlab)singleSlab, (BlockModSlab)new BlockBiotiteSlab(true));
        BlockModStairs.initStairs((Block)biotite_block, (int)0, (BlockStairs)new BlockBiotiteStairs());
        VanillaWalls.add("biotite", biotite_block, 0, this.enableWalls);
        RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack(biotite_block), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), new ItemStack(biotite)});
        RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack(biotite_block, 2, 1), (Object[])new Object[]{"B", "B", Character.valueOf('B'), new ItemStack((Block)singleSlab)});
        RecipeHandler.addOreDictRecipe((ItemStack)new ItemStack(biotite_block, 2, 2), (Object[])new Object[]{"B", "B", Character.valueOf('B'), new ItemStack(biotite_block)});
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BiotiteGenerator(this.clusterSize, this.clusterCount), (int)0);
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        if (this.generateByDragon && event.getEntityLiving() instanceof EntityDragon && !event.getEntity().field_70170_p.field_72995_K) {
            EntityDragon dragon = (EntityDragon)event.getEntity();
            if (dragon.field_70995_bG > 0 && dragon.field_70995_bG % this.generationDelay == 0) {
                Random rand = dragon.field_70170_p.field_73012_v;
                BlockPos basePos = dragon.func_180425_c();
                basePos = new BlockPos(basePos.func_177958_n() - 128, 0, basePos.func_177952_p() - 128);
                for (int i = 0; i < this.clustersPerTick; ++i) {
                    BlockPos pos = basePos.func_177982_a(rand.nextInt(256), rand.nextInt(64), rand.nextInt(256));
                    BiotiteGenerator.generator.func_180709_b(dragon.field_70170_p, rand, pos);
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

