/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import mcjty.theoneprobe.network.NetworkTools;

public class ElementProgress
implements IElement {
    private final long current;
    private final long max;
    private final IProgressStyle style;
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public ElementProgress(long current, long max, IProgressStyle style) {
        this.current = current;
        this.max = max;
        this.style = style;
    }

    public ElementProgress(ByteBuf buf) {
        this.current = buf.readLong();
        this.max = buf.readLong();
        this.style = new ProgressStyle().width(buf.readInt()).height(buf.readInt()).prefix(NetworkTools.readStringUTF8(buf)).suffix(NetworkTools.readStringUTF8(buf)).borderColor(buf.readInt()).filledColor(buf.readInt()).alternateFilledColor(buf.readInt()).backgroundColor(buf.readInt()).showText(buf.readBoolean()).numberFormat(NumberFormat.values()[buf.readByte()]).lifeBar(buf.readBoolean());
    }

    public static String format(long in, NumberFormat style) {
        switch (style) {
            case FULL: {
                return Long.toString(in);
            }
            case COMPACT: {
                int unit = 1000;
                if (in < (long)unit) {
                    return Long.toString(in);
                }
                int exp = (int)(Math.log(in) / Math.log(unit));
                char pre = "KMGTP".charAt(exp - 1);
                return String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre));
            }
            case COMMAS: {
                return dfCommas.format(in);
            }
        }
        return Long.toString(in);
    }

    @Override
    public void render(int x, int y) {
        ElementProgressRender.render(this.style, this.current, this.max, x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public int getWidth() {
        if (this.style.isLifeBar()) {
            if (this.current * 4L >= (long)this.style.getWidth()) {
                return 100;
            }
            return (int)(this.current * 4L + 2L);
        }
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.current);
        buf.writeLong(this.max);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        NetworkTools.writeStringUTF8(buf, this.style.getPrefix());
        NetworkTools.writeStringUTF8(buf, this.style.getSuffix());
        buf.writeInt(this.style.getBorderColor());
        buf.writeInt(this.style.getFilledColor());
        buf.writeInt(this.style.getAlternatefilledColor());
        buf.writeInt(this.style.getBackgroundColor());
        buf.writeBoolean(this.style.isShowText());
        buf.writeByte(this.style.getNumberFormat().ordinal());
        buf.writeBoolean(this.style.isLifeBar());
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_PROGRESS;
    }
}

