/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mcjty.theoneprobe.config.Config;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class CommandTopCfg
implements ICommand {
    private static Map<String, Consumer<String[]>> SUBCOMMANDS = new HashMap<String, Consumer<String[]>>();

    public String func_71517_b() {
        return "topcfg";
    }

    public String func_71518_a(ICommandSender sender) {
        String args = StringUtils.join(SUBCOMMANDS.keySet(), (String)" | ");
        return "topcfg [ " + args + " ]";
    }

    private static void setPos(String[] args) {
        if (args.length != 5) {
            return;
        }
        try {
            int leftx = Integer.parseInt(args[1]);
            int topy = Integer.parseInt(args[2]);
            int rightx = Integer.parseInt(args[3]);
            int bottomy = Integer.parseInt(args[4]);
            Config.setPos(leftx, topy, rightx, bottomy);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Too few parameters"));
            return;
        }
        String cmd = args[0];
        Consumer<String[]> consumer = SUBCOMMANDS.get(cmd);
        if (consumer == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown style option!"));
        } else {
            consumer.accept(args);
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return CommandBase.func_175762_a((String[])args, SUBCOMMANDS.keySet());
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    static {
        SUBCOMMANDS.put("center", s -> Config.setPos(-1, -1, -1, -1));
        SUBCOMMANDS.put("topleft", s -> Config.setPos(5, 5, -1, -1));
        SUBCOMMANDS.put("topcenter", s -> Config.setPos(-1, 5, -1, -1));
        SUBCOMMANDS.put("topright", s -> Config.setPos(-1, 5, 5, -1));
        SUBCOMMANDS.put("bottomleft", s -> Config.setPos(5, -1, -1, 20));
        SUBCOMMANDS.put("bottomcenter", s -> Config.setPos(-1, -1, -1, 20));
        SUBCOMMANDS.put("bottomright", s -> Config.setPos(-1, -1, 5, 20));
        SUBCOMMANDS.put("centerleft", s -> Config.setPos(5, -1, -1, -1));
        SUBCOMMANDS.put("centerright", s -> Config.setPos(-1, -1, 5, -1));
        SUBCOMMANDS.put("transparent", s -> Config.setBoxStyle(0, 0, 0));
        SUBCOMMANDS.put("setpos", CommandTopCfg::setPos);
        SUBCOMMANDS.put("opaque", s -> Config.setBoxStyle(2, -6710887, -16764058));
        SUBCOMMANDS.put("default", s -> Config.setBoxStyle(2, -6710887, 1426089625));
        SUBCOMMANDS.put("liquids", s -> Config.setLiquids(true));
        SUBCOMMANDS.put("noliquids", s -> Config.setLiquids(false));
        SUBCOMMANDS.put("compactequalstacks", s -> Config.setCompactEqualStacks(true));
        SUBCOMMANDS.put("dontcompactequalstacks", s -> Config.setCompactEqualStacks(false));
        SUBCOMMANDS.put("extendedinmain", s -> Config.setExtendedInMain(true));
        SUBCOMMANDS.put("defaultinmain", s -> Config.setExtendedInMain(false));
    }
}

