/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.ProbeHitEntityData;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.network.PacketHandler;
import mcjty.theoneprobe.network.PacketReturnEntityInfo;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetEntityInfo
implements IMessage {
    private int dim;
    private UUID uuid;
    private ProbeMode mode;
    private Vec3d hitVec;

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.mode = ProbeMode.values()[buf.readByte()];
        if (buf.readBoolean()) {
            this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeByte(this.mode.ordinal());
        if (this.hitVec == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeDouble(this.hitVec.field_72450_a);
            buf.writeDouble(this.hitVec.field_72448_b);
            buf.writeDouble(this.hitVec.field_72449_c);
        }
    }

    public PacketGetEntityInfo() {
    }

    public PacketGetEntityInfo(int dim, ProbeMode mode, RayTraceResult mouseOver, Entity entity) {
        this.dim = dim;
        this.uuid = entity.getPersistentID();
        this.mode = mode;
        this.hitVec = mouseOver.field_72307_f;
    }

    private static boolean hasProbeInEitherHand(EntityPlayer player) {
        return ModItems.isProbe(player.func_184586_b(EnumHand.MAIN_HAND)) || ModItems.isProbe(player.func_184586_b(EnumHand.OFF_HAND));
    }

    private static ProbeInfo getProbeInfo(EntityPlayer player, ProbeMode mode, World world, Entity entity, Vec3d hitVec) {
        if (Config.needsProbe == 2 && !PacketGetEntityInfo.hasProbeInEitherHand(player)) {
            return null;
        }
        ProbeInfo probeInfo = TheOneProbe.theOneProbeImp.create();
        ProbeHitEntityData data = new ProbeHitEntityData(hitVec);
        IProbeConfig probeConfig = TheOneProbe.theOneProbeImp.createProbeConfig();
        List<IProbeConfigProvider> configProviders = TheOneProbe.theOneProbeImp.getConfigProviders();
        for (IProbeConfigProvider configProvider : configProviders) {
            configProvider.getProbeConfig(probeConfig, player, world, entity, data);
        }
        Config.setRealConfig(probeConfig);
        List<IProbeInfoEntityProvider> entityProviders = TheOneProbe.theOneProbeImp.getEntityProviders();
        for (IProbeInfoEntityProvider provider : entityProviders) {
            try {
                provider.addProbeEntityInfo(mode, probeInfo, player, world, entity, data);
            }
            catch (Throwable e) {
                ThrowableIdentity.registerThrowable(e);
                probeInfo.text(TextFormatting.RED + "Error: " + provider.getID());
            }
        }
        return probeInfo;
    }

    public static class Handler
    implements IMessageHandler<PacketGetEntityInfo, IMessage> {
        public IMessage onMessage(PacketGetEntityInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetEntityInfo message, MessageContext ctx) {
            Entity entity;
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world != null && (entity = world.func_175733_a(message.uuid)) != null) {
                ProbeInfo probeInfo = PacketGetEntityInfo.getProbeInfo((EntityPlayer)ctx.getServerHandler().field_147369_b, message.mode, (World)world, entity, message.hitVec);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketReturnEntityInfo(message.uuid, probeInfo), ctx.getServerHandler().field_147369_b);
            }
        }
    }
}

