/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.proxy;

import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.commands.CommandTopCfg;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.keys.KeyBindings;
import mcjty.theoneprobe.keys.KeyInputHandler;
import mcjty.theoneprobe.proxy.CommonProxy;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        ModItems.initClient();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTopCfg());
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        KeyBindings.init();
    }

    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            return;
        }
        if (Config.holdKeyToMakeVisible ? !KeyBindings.toggleVisible.func_151470_d() : !Config.isVisible) {
            return;
        }
        if (this.hasItemInEitherHand(ModItems.creativeProbe)) {
            OverlayRenderer.renderHUD(ProbeMode.DEBUG, event.getPartialTicks());
        } else if (Config.needsProbe > 0) {
            if (this.hasProbeInHand(EnumHand.MAIN_HAND) || this.hasProbeInHand(EnumHand.OFF_HAND) || this.hasProbeInHelmet()) {
                OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getPartialTicks());
            }
        } else {
            OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getPartialTicks());
        }
    }

    private ProbeMode getModeForPlayer() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (Config.extendedInMain && this.hasItemInMainHand(ModItems.probe)) {
            return ProbeMode.EXTENDED;
        }
        return player.func_70093_af() ? ProbeMode.EXTENDED : ProbeMode.NORMAL;
    }

    private boolean hasProbeInHand(EnumHand hand) {
        ItemStack item = Minecraft.func_71410_x().field_71439_g.func_184586_b(hand);
        if (item == null) {
            return false;
        }
        if (item.func_77973_b() == ModItems.probe || item.func_77973_b() == ModItems.creativeProbe) {
            return true;
        }
        if (item.func_77978_p() == null) {
            return false;
        }
        return item.func_77978_p().func_74764_b(ModItems.PROBETAG_HAND);
    }

    private boolean hasProbeInHelmet() {
        ItemStack helmet = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(3);
        if (helmet == null) {
            return false;
        }
        if (helmet.func_77978_p() == null) {
            return false;
        }
        return helmet.func_77978_p().func_74764_b(ModItems.PROBETAG);
    }

    private boolean hasItemInEitherHand(Item item) {
        ItemStack mainHeldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHeldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.OFF_HAND);
        return mainHeldItem != null && mainHeldItem.func_77973_b() == item || offHeldItem != null && offHeldItem.func_77973_b() == item;
    }

    private boolean hasItemInMainHand(Item item) {
        ItemStack mainHeldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        return mainHeldItem != null && mainHeldItem.func_77973_b() == item;
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }
}

