/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.api.multiblock.rectangular;

import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.api.multiblock.rectangular.PartPosition;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.BlockFacings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class RectangularMultiblockTileEntityBase
extends MultiblockTileEntityBase {
    private PartPosition position = PartPosition.Unknown;
    private BlockFacings outwardFacings = BlockFacings.NONE;

    @Nonnull
    public BlockFacings getOutwardsDir() {
        return this.outwardFacings;
    }

    @Nonnull
    public PartPosition getPartPosition() {
        return this.position;
    }

    @Nullable
    public EnumFacing getOutwardFacing() {
        BlockFacings out;
        EnumFacing facing;
        EnumFacing enumFacing = facing = null != this.position ? this.position.getFacing() : null;
        if (null == facing && !(out = this.getOutwardsDir()).none() && 1 == out.countFacesIf(true)) {
            facing = out.firstIf(true);
        }
        return facing;
    }

    @Nullable
    public EnumFacing getOutwardFacingFromWorldPosition() {
        BlockFacings facings = null;
        MultiblockControllerBase controller = this.getMultiblockController();
        if (null != controller) {
            BlockPos position = this.getWorldPosition();
            BlockPos min = controller.getMinimumCoord();
            BlockPos max = controller.getMaximumCoord();
            int x = position.func_177958_n();
            int y = position.func_177956_o();
            int z = position.func_177952_p();
            facings = BlockFacings.from(min.func_177956_o() == y, max.func_177956_o() == y, min.func_177952_p() == z, max.func_177952_p() == z, min.func_177958_n() == x, max.func_177958_n() == x);
        }
        return null != facings && !facings.none() && 1 == facings.countFacesIf(true) ? facings.firstIf(true) : null;
    }

    @Override
    public void onAttached(MultiblockControllerBase newController) {
        super.onAttached(newController);
        this.recalculateOutwardsDirection(newController.getMinimumCoord(), newController.getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        this.recalculateOutwardsDirection(controller.getMinimumCoord(), controller.getMaximumCoord());
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwardFacings = BlockFacings.NONE;
    }

    public void recalculateOutwardsDirection(BlockPos minCoord, BlockPos maxCoord) {
        BlockPos myPosition = this.func_174877_v();
        int myX = myPosition.func_177958_n();
        int myY = myPosition.func_177956_o();
        int myZ = myPosition.func_177952_p();
        int facesMatching = 0;
        boolean downFacing = myY == minCoord.func_177956_o();
        boolean upFacing = myY == maxCoord.func_177956_o();
        boolean northFacing = myZ == minCoord.func_177952_p();
        boolean southFacing = myZ == maxCoord.func_177952_p();
        boolean westFacing = myX == minCoord.func_177958_n();
        boolean eastFacing = myX == maxCoord.func_177958_n();
        this.outwardFacings = BlockFacings.from(downFacing, upFacing, northFacing, southFacing, westFacing, eastFacing);
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        this.position = facesMatching <= 0 ? PartPosition.Interior : (facesMatching >= 3 ? PartPosition.FrameCorner : (facesMatching == 2 ? (!eastFacing && !westFacing ? PartPosition.FrameEastWest : (!southFacing && !northFacing ? PartPosition.FrameSouthNorth : PartPosition.FrameUpDown)) : (eastFacing ? PartPosition.EastFace : (westFacing ? PartPosition.WestFace : (southFacing ? PartPosition.SouthFace : (northFacing ? PartPosition.NorthFace : (upFacing ? PartPosition.TopFace : PartPosition.BottomFace)))))));
    }

    public abstract boolean isGoodForFrame(IMultiblockValidator var1);

    public abstract boolean isGoodForSides(IMultiblockValidator var1);

    public abstract boolean isGoodForTop(IMultiblockValidator var1);

    public abstract boolean isGoodForBottom(IMultiblockValidator var1);

    public abstract boolean isGoodForInterior(IMultiblockValidator var1);
}

