/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.api;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.commons.lang3.tuple.Pair;

public final class IMC {
    private static final String MOD_ID = "OpenComputers";

    public static void registerAssemblerFilter(String callback) {
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerAssemblerFilter", (String)callback);
    }

    public static void registerAssemblerTemplate(String name, String select, String validate, String assemble, Class host, int[] containerTiers, int[] upgradeTiers, Iterable<Pair<String, Integer>> componentSlots) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (name != null) {
            nbt.func_74778_a("name", name);
        }
        nbt.func_74778_a("select", select);
        nbt.func_74778_a("validate", validate);
        nbt.func_74778_a("assemble", assemble);
        if (host != null) {
            nbt.func_74778_a("hostClass", host.getName());
        }
        NBTTagList containersNbt = new NBTTagList();
        if (containerTiers != null) {
            for (int tier : containerTiers) {
                NBTTagCompound slotNbt = new NBTTagCompound();
                slotNbt.func_74768_a("tier", tier);
                containersNbt.func_74742_a((NBTBase)slotNbt);
            }
        }
        if (containersNbt.func_74745_c() > 0) {
            nbt.func_74782_a("containerSlots", (NBTBase)containersNbt);
        }
        NBTTagList upgradesNbt = new NBTTagList();
        if (upgradeTiers != null) {
            for (int tier : upgradeTiers) {
                NBTTagCompound slotNbt = new NBTTagCompound();
                slotNbt.func_74768_a("tier", tier);
                upgradesNbt.func_74742_a((NBTBase)slotNbt);
            }
        }
        if (upgradesNbt.func_74745_c() > 0) {
            nbt.func_74782_a("upgradeSlots", (NBTBase)upgradesNbt);
        }
        NBTTagList componentsNbt = new NBTTagList();
        if (componentSlots != null) {
            for (Pair<String, Integer> slot : componentSlots) {
                if (slot == null) {
                    componentsNbt.func_74742_a((NBTBase)new NBTTagCompound());
                    continue;
                }
                NBTTagCompound slotNbt = new NBTTagCompound();
                slotNbt.func_74778_a("type", (String)slot.getLeft());
                slotNbt.func_74768_a("tier", ((Integer)slot.getRight()).intValue());
                componentsNbt.func_74742_a((NBTBase)slotNbt);
            }
        }
        if (componentsNbt.func_74745_c() > 0) {
            nbt.func_74782_a("componentSlots", (NBTBase)componentsNbt);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerAssemblerTemplate", (NBTTagCompound)nbt);
    }

    public static void registerDisassemblerTemplate(String name, String select, String disassemble) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (name != null) {
            nbt.func_74778_a("name", name);
        }
        nbt.func_74778_a("select", select);
        nbt.func_74778_a("disassemble", disassemble);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerDisassemblerTemplate", (NBTTagCompound)nbt);
    }

    public static void registerToolDurabilityProvider(String callback) {
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerToolDurabilityProvider", (String)callback);
    }

    public static void registerWrenchTool(String callback) {
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerWrenchTool", (String)callback);
    }

    public static void registerWrenchToolCheck(String callback) {
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerWrenchToolCheck", (String)callback);
    }

    public static void registerItemCharge(String name, String canCharge, String charge) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", name);
        nbt.func_74778_a("canCharge", canCharge);
        nbt.func_74778_a("charge", charge);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerItemCharge", (NBTTagCompound)nbt);
    }

    public static void registerInkProvider(String callback) {
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerInkProvider", (String)callback);
    }

    public static void blacklistPeripheral(Class peripheral) {
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"blacklistPeripheral", (String)peripheral.getName());
    }

    public static void blacklistHost(String name, Class host, ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", name);
        nbt.func_74778_a("host", host.getName());
        NBTTagCompound stackNbt = new NBTTagCompound();
        stack.func_77955_b(stackNbt);
        nbt.func_74782_a("item", (NBTBase)stackNbt);
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"blacklistHost", (NBTTagCompound)nbt);
    }

    public static void registerCustomPowerSystem() {
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerCustomPowerSystem", (String)"true");
    }

    public static void registerProgramDiskLabel(String programName, String diskLabel, String ... architectures) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("program", programName);
        nbt.func_74778_a("label", diskLabel);
        if (architectures != null && architectures.length > 0) {
            NBTTagList architecturesNbt = new NBTTagList();
            for (String architecture : architectures) {
                architecturesNbt.func_74742_a((NBTBase)new NBTTagString(architecture));
            }
            nbt.func_74782_a("architectures", (NBTBase)architecturesNbt);
        }
        FMLInterModComms.sendMessage((String)MOD_ID, (String)"registerProgramDiskLabel", (NBTTagCompound)nbt);
    }

    private IMC() {
    }
}

