/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.api.event;

import li.cil.oc.api.internal.Rack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class RackMountableRenderEvent
extends Event {
    public final Rack rack;
    public final int mountable;
    public final NBTTagCompound data;

    public RackMountableRenderEvent(Rack rack, int mountable, NBTTagCompound data) {
        this.rack = rack;
        this.mountable = mountable;
        this.data = data;
    }

    public static class TileEntity
    extends RackMountableRenderEvent {
        public final float v0;
        public final float v1;

        public TileEntity(Rack rack, int mountable, NBTTagCompound data, float v0, float v1) {
            super(rack, mountable, data);
            this.v0 = v0;
            this.v1 = v1;
        }

        public void renderOverlay(ResourceLocation texture) {
            this.renderOverlay(texture, 0.0f, 1.0f);
        }

        public void renderOverlay(ResourceLocation texture, float u0, float u1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            Tessellator t = Tessellator.func_178181_a();
            VertexBuffer r = t.func_178180_c();
            r.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            r.func_181662_b((double)u0, (double)this.v1, 0.0).func_187315_a((double)u0, (double)this.v1).func_181675_d();
            r.func_181662_b((double)u1, (double)this.v1, 0.0).func_187315_a((double)u1, (double)this.v1).func_181675_d();
            r.func_181662_b((double)u1, (double)this.v0, 0.0).func_187315_a((double)u1, (double)this.v0).func_181675_d();
            r.func_181662_b((double)u0, (double)this.v0, 0.0).func_187315_a((double)u0, (double)this.v0).func_181675_d();
            t.func_78381_a();
        }

        public void renderOverlayFromAtlas(ResourceLocation texture) {
            this.renderOverlayFromAtlas(texture, 0.0f, 1.0f);
        }

        public void renderOverlayFromAtlas(ResourceLocation texture, float u0, float u1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
            Tessellator t = Tessellator.func_178181_a();
            VertexBuffer r = t.func_178180_c();
            r.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            r.func_181662_b((double)u0, (double)this.v1, 0.0).func_187315_a((double)icon.func_94214_a((double)(u0 * 16.0f)), (double)icon.func_94207_b((double)(this.v1 * 16.0f))).func_181675_d();
            r.func_181662_b((double)u1, (double)this.v1, 0.0).func_187315_a((double)icon.func_94214_a((double)(u1 * 16.0f)), (double)icon.func_94207_b((double)(this.v1 * 16.0f))).func_181675_d();
            r.func_181662_b((double)u1, (double)this.v0, 0.0).func_187315_a((double)icon.func_94214_a((double)(u1 * 16.0f)), (double)icon.func_94207_b((double)(this.v0 * 16.0f))).func_181675_d();
            r.func_181662_b((double)u0, (double)this.v0, 0.0).func_187315_a((double)icon.func_94214_a((double)(u0 * 16.0f)), (double)icon.func_94207_b((double)(this.v0 * 16.0f))).func_181675_d();
            t.func_78381_a();
        }
    }

    @Cancelable
    public static class Block
    extends RackMountableRenderEvent {
        public final EnumFacing side;
        private TextureAtlasSprite frontTextureOverride;

        public Block(Rack rack, int mountable, NBTTagCompound data, EnumFacing side) {
            super(rack, mountable, data);
            this.side = side;
        }

        public TextureAtlasSprite getFrontTextureOverride() {
            return this.frontTextureOverride;
        }

        public void setFrontTextureOverride(TextureAtlasSprite texture) {
            this.frontTextureOverride = texture;
        }
    }
}

